'use strict';

/**
 * @param {Egg.Application} app - egg application
 */
module.exports = app => {
  const { controller } = app;
  const router = app.router.namespace(app.config.projectRootPath);

  router.post('/:type/tasks', controller.task.create); // 创建任务
  router.get('/:type/tasks/:taskId', controller.task.show); // 获取任务状态
  router.post('/:type/tasks/:taskId/submit', controller.task.submit); // 提交任务参数
  router.post('/:type/tasks/:taskId/capture', controller.task.fetchCapture); // 获取验证码

  router.post('/:type/callback', controller.task.handleCallback); // 处理回调结果，不对外

  // router.get('/:type/scripts', controller.script.fetchScripts); // 获取所有脚本信息
  router.get('/:type/scripts/:scriptId', controller.script.fetchOneScripts); // 获取单一脚本信息

  router.get('/:type/help/:scriptId', controller.script.fetchHelpInfo); // 获取帮助信息
  router.get('/:type/notice/:scriptId', controller.script.fetchNoticeInfo);// 获取提示信息
  router.get('/:type/query_button/:scriptId', controller.script.fetchQueryButtonInfo); // 获取查询按钮信息

  router.get('/:type/params', controller.script.fetchParamsInfo); // 获取登录参数字典
  // router.post('/:type/tokens', controller.token.create); // 创建token
  router.post('/:type/orders', controller.order.create); // 创建订单号

  router.get('/:type/hubs/:hubId/scripts', controller.script.fetchHubSeripts);// 根据hubId 获取脚本数据（数组）

  router.get('/:type/theme/:appKey', controller.partner.show);// 根据appkey查询合作方主题

  router.get('/agreements/:id', controller.partner.fetchAgreements);// 查询协议


};
