/*
 * @Descripttion: 
 * @version: 
 * @Author: jd
 * @Date: 2019-12-02 17:25:35
 * @LastEditors: jd
 * @LastEditTime: 2019-12-03 15:28:31
 */
'use strict';

const Service = require('egg').Service;

class TaskService extends Service {
  constructor(ctx) {
    super(ctx);
    const { config: { taskAPI, LOCK_KEY } } = this;
    this.taskAPI = taskAPI;
    this.baseURL = taskAPI.host;
    this.citylistURL = taskAPI.citylist;
    this.LOCK_KEY = LOCK_KEY;
  }

  checkType(type) {
    const { ctx } = this;
    let scriptsType = '';
    switch (type) {
      case 'gjj':
        scriptsType = ':18524/gjjfindpwd';
        break;
      case 'shebao':
        scriptsType = ':18523/shebaofindpwd';
        break;
      case 'incomeTax':
        scriptsType = ':18518/gsfindpwd';
        break;
      default:
        ctx.throw(422, { message: '无效的类型' });
        break;
    }
    return scriptsType;
  }

  _request(url, opts) {
    const { ctx, baseURL } = this;
    url = `${baseURL}${url}`;
    opts = {
      charset: 'utf-8',
      timeout: [30000, 30000],
      dataType: 'json',
      ...opts,
    };
    return ctx.curl(url, opts);
  }

  _checkSuccess(result) {
    if (result.status !== 200) {
      const errorMsg = result.data && result.data.error_msg ? result.data.error_msg : 'unknown error';
      this.ctx.throw(result.status, errorMsg);
    }
    if (result.data.code !== 0) {
      this.ctx.throw(400, { message: result.data.msg || result.data.data.img, code: result.data.code || -1 });
    }
  }
  async create(data, type) {
    const { ctx, taskAPI } = this;
    const { createTaskUrl } = taskAPI;
    const result = await this._request(this.checkType(type) + createTaskUrl, {
      method: 'post',
      data: { cityId: data },
      contentType: 'json',
    });
    ctx.logger.info(`【Task】create ${this.checkType(type) + createTaskUrl} cityId: ${data} result:`, JSON.stringify(result.data));
    this._checkSuccess(result);
    return result.data.data.taskId;
  }

  async fetchCapture({ taskId, taskType }) {
    const { taskAPI, ctx } = this;
    const { fetchCodeUrl } = taskAPI;
    const result = await this._request(this.checkType(type) + fetchCodeUrl, {
      method: 'post',
      data: {
        taskId,
        taskType,
      },
      contentType: 'json',
    });
    ctx.logger.info(`【Task】fetchCapture ${this.checkType(type) + fetchCodeUrl} params`, JSON.stringify({
      taskId,
      type,
      taskType,
    }), JSON.stringify(result.data));
    this._checkSuccess(result);
    return result.data.data;
  }
  async submit(data) {
    const { taskAPI, ctx } = this;
    const { submitTaskUrl } = taskAPI;
    const result = await this._request(this.checkType(type) + submitTaskUrl, {
      method: 'post',
      data,
      contentType: 'json',
    });
    ctx.logger.info(`【Task】submit ${this.checkType(type) + submitTaskUrl} params`, JSON.stringify(data), JSON.stringify(result.data));
    this._checkSuccess(result);
    return result;
  }
  async fetchTask(data) {
    const { taskAPI, ctx } = this;
    const { fetchTaskUrl } = taskAPI;
    const result = await this._request(this.checkType(type) + fetchTaskUrl, {
      method: 'post',
      data,
      contentType: 'json',
    });
    ctx.logger.info(`【Task】fetchTask ${this.checkType(type) + fetchTaskUrl} params`, JSON.stringify(data), JSON.stringify(result.data));
    return result.data;
  }

}

module.exports = TaskService;
