'use strict';

const Service = require('egg').Service;

class PartnerService extends Service {
  constructor(ctx) {
    super(ctx);
    const { config: { partnerAPI } } = this;
    this.partnerAPI = partnerAPI;
  }

  async fetchTheme(appKey, type) {
    const { ctx, partnerAPI: { fetchTheme, host, redisThemePrefix } } = this;
    if (appKey) {
      const data = await this.app.redis.get(redisThemePrefix + type + appKey);
      if (data) {
        try {
          return JSON.parse(data);
        } catch (err) {
          ctx.logger.error('【Scripts】fetchParams', redisThemePrefix + appKey, 'result:', data, err);
          await this.app.redis.del(redisThemePrefix + type + appKey);
        }
      }
    }
    const ret = await ctx.curl(`${host + fetchTheme}`, {
      charset: 'utf-8',
      timeout: [30000, 30000],
      dataType: 'json',
      method: 'GET',
      data: {
        appKey,
        subject: 'hf',
      },
    });
    ctx.logger.info(`【Partner】 fetchTheme ${host + fetchTheme}/${appKey}`, JSON.stringify(ret.data));
    if (ret.status === 200 && ret.data && ret.data.length > 0 && ret.data[0].appKey === appKey) {
      await this.app.redis.set(redisThemePrefix + type + appKey, JSON.stringify(ret.data[0]), 'EX', 300);
    }
    return ret.data[0];
  }

  async fetchInfo(appKey) {
    const { ctx, partnerAPI: { fetchInfo, host, redisInfoPrefix } } = this;
    if (appKey) {
      const data = await this.app.redis.get(redisInfoPrefix + appKey);
      if (data) {
        try {
          return JSON.parse(data);
        } catch (err) {
          ctx.logger.error('【Scripts】fetchInfo', redisInfoPrefix + appKey, 'result:', data, err);
          await this.app.redis.del(redisInfoPrefix + appKey);
        }
      }
    }
    const ret = await ctx.curl(`${host + fetchInfo}`, {
      charset: 'utf-8',
      timeout: [30000, 30000],
      dataType: 'json',
      method: 'GET',
      data: {
        appKey,
      },
    });
    ctx.logger.info(`【Partner】 fetchInfo ${host + fetchInfo}?appKey=${appKey}`, JSON.stringify(ret.data));
    if (ret.status === 200 && ret.data && ret.data.length > 0 && ret.data[0].appKey === appKey) {
      await this.app.redis.set(redisInfoPrefix + appKey, JSON.stringify(ret.data[0]), 'EX', 300);
    }
    return ret.data[0];
  }

  async checkInfo(appKey, type) {
    const { ctx } = this;
    const appKeyInfo = await this.fetchInfo(appKey, type);
    if (!(appKeyInfo && appKeyInfo.valid === true)) {
      ctx.throw(422, { message: '无效的appKey' });
    }
    switch (type) {
    case 'gjj':
      if (appKeyInfo.enableHf !== true) {
        ctx.throw(422, { message: '未开通此服务' });
      }
      break;
    case 'shebao':
      if (appKeyInfo.enableSs === true) {
        ctx.throw(422, { message: '未开通此服务' });
      }
      break;
    case 'incomeTax':
      if (appKeyInfo.enableIt === true) {
        ctx.throw(422, { message: '未开通此服务' });
      }
      break;
    default:
      ctx.throw(422, { message: '无效的类型' });
      break;
    }
  }

  async fetchAgreements(id) {
    const { ctx, partnerAPI: { fetchAgreements, host, redisAgreementsPrefix } } = this;
    const data = await this.app.redis.get(redisAgreementsPrefix + id);
    if (data) {
      try {
        return JSON.parse(data);
      } catch (err) {
        ctx.logger.error('【Partner】 fetchAgreements', redisAgreementsPrefix + id, 'result:', JSON.stringify(data), err);
        await this.app.redis.del(redisAgreementsPrefix + id);
      }
    }
    const url = `${host + fetchAgreements}/${id}`;
    const ret = await ctx.curl(url, {
      charset: 'utf-8',
      timeout: [30000, 30000],
      dataType: 'json',
      method: 'GET',
    });
    ctx.logger.info(`【Partner】 fetchAgreements ${url}`, JSON.stringify(ret.data));
    if (ret.status === 200 && ret.data && ret.data.id === id) {
      await this.app.redis.set(redisAgreementsPrefix + id, JSON.stringify(ret.data), 'EX', 300);
    }
    return ret.data;
  }

}

module.exports = PartnerService;
