/*
 * @Descripttion: 
 * @version: 
 * @Author: jd
 * @Date: 2019-12-02 17:25:35
 * @LastEditors: jd
 * @LastEditTime: 2019-12-04 17:39:40
 */
'use strict';

const Controller = require('egg').Controller;

class OrderController extends Controller {
  constructor(ctx) {
    super(ctx);
    this.createRule = {
      appKey: 'string',
      userId: {
        type: 'string',
        required: true,
      },
    };
  }

  async create() {
    const { ctx, service } = this;
    ctx.validate(this.createRule);
    const { appKey, userId } = ctx.request.body;
    const { type } = ctx.params;
    await service.partner.checkInfo(appKey, type);
    const orderId = ctx.helper.getUuid();
    const object = {
      orderId,
      taskId: '',
      userId,
      cityId: '',
      type,
      appKey,
      status: 'init',
    };
    await service.order.create(object);
    ctx.success({ orderId: object.orderId });
  }

}

module.exports = OrderController;
