'use strict';

const Controller = require('egg').Controller;

class ScriptController extends Controller {

  constructor(ctx) {
    super(ctx);
    this.cityListRule = {
      appKey: 'string',
    };
    this.paramsRule = {
      type: {
        type: 'enum',
        required: true,
        values: ['gjj', 'shebao', 'incomeTax'],
      },
      scriptId: {
        type: 'string',
        required: true,
        format: /^\d+$/,
      },
    };
    this.typeRule = {
      type: {
        type: 'enum',
        required: true,
        values: ['gjj', 'shebao', 'incomeTax'],
      },
    };
  }
  // async fetchScripts() {
  //   const { ctx, service } = this;
  //   ctx.validate(this.paramsRule, ctx.query);
  //   const { appKey, type } = ctx.query;
  //   let limitScriptsList = false;
  //   if (appKey) {
  //     const ret = await service.partner.fetchInfo(appKey);
  //     if (ret && (type === 'gjj')) {
  //       limitScriptsList = ret.hfExcludeScripts;
  //     }
  //   }
  //   let data = await service.scripts.fetchScripts(type);
  //   if (limitScriptsList) {
  //     data = data.filter(item => {
  //       return !(limitScriptsList.includes(item.id));
  //     });
  //   }
  //   ctx.success(data);
  // }

  async fetchOneScripts() {
    const { ctx, service } = this;
    ctx.validate(this.paramsRule, ctx.params);
    let { scriptId, type } = ctx.params;
    if (scriptId === 'auto') {
      const ret = await service.scripts.fetchScriptIdByIp(type);
      scriptId = ret.scriptId;
    }
    const data = await service.scripts.fetchOneScripts(scriptId, type);
    ctx.success(data);
  }
  async fetchParamsInfo() {
    const { ctx, service } = this;
    ctx.validate(this.typeRule, ctx.params);
    const { refresh = false } = ctx.query;
    const { type } = ctx.params;
    const data = await service.scripts.fetchParams(refresh, type);
    ctx.success(data);
  }

  async fetchHelpInfo() {
    const { ctx, service } = this;
    ctx.validate(this.paramsRule, ctx.params);
    const { scriptId, type } = ctx.params;
    const data = await service.scripts.fetchHelp(scriptId, type);
    ctx.success(data);
  }

  async fetchQueryButtonInfo() {
    const { ctx, service } = this;
    ctx.validate(this.paramsRule, ctx.params);
    const { scriptId, type } = ctx.params;
    const data = await service.scripts.fetchQueryButton(scriptId, type);
    ctx.success(data);
  }

  async fetchNoticeInfo() {
    const { ctx, service } = this;
    ctx.validate(this.paramsRule, ctx.params);
    const { scriptId, type } = ctx.params;
    const data = await service.scripts.fetchNotice(scriptId, type);
    ctx.success(data);
  }

  async fetchHubSeripts() {
    const { ctx, service } = this;
    ctx.validate(this.typeRule, ctx.params);
    let { hubId, type } = ctx.params;
    if (hubId === 'auto') {
      const ret = await service.scripts.fetchScriptIdByIp(type);
      hubId = ret.hubId;
    }
    const data = await service.scripts.fetchHubSeripts(hubId, type);
    ctx.success(data);
  }
}

module.exports = ScriptController;
