'use strict';

module.exports = app => {
  const { DataTypes } = app.Sequelize;

  const taskStatus = app.model.define('taskStatus', {
    id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      autoIncrement: true,
      primaryKey: true,
      field: 'id',
    },
    orderId: {
      type: DataTypes.STRING(50),
      allowNull: false,
      defaultValue: '',
      field: 'orderId',
    },
    taskId: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: '',
      field: 'taskId',
    },
    userId: {
      type: DataTypes.STRING(255),
      allowNull: true,
      defaultValue: '',
      field: 'userId',
    },
    cityId: {
      type: DataTypes.STRING(10),
      allowNull: true,
      defaultValue: '',
      field: 'cityId',
    },
    type: {
      type: DataTypes.STRING(50),
      allowNull: false,
      defaultValue: '',
      field: 'type',
    },
    appKey: {
      type: DataTypes.STRING(50),
      allowNull: false,
      field: 'appKey',
    },
    params: {
      type: DataTypes.STRING(500),
      allowNull: false,
      defaultValue: '',
      field: 'params',
      set(val) {
        const note = this.getDataValue('params');
        if (!note) {
          this.setDataValue('params', JSON.stringify(val));
        }
      },
    },
    status: {
      type: DataTypes.STRING(20),
      allowNull: true,
      defaultValue: '',
      field: 'status',
    },
    note: {
      type: DataTypes.STRING(1000),
      allowNull: true,
      defaultValue: '',
      field: 'note',
      get() {
        const note = this.getDataValue('note');
        if (note) {
          try {
            return JSON.parse(note);
          } catch (error) {
            return {};
          }
        }
        return {};
      },
      set(val) {
        this.setDataValue('note', JSON.stringify(val));
      },
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: app.Sequelize.literal('CURRENT_TIMESTAMP'),
      field: 'createDate',
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: app.Sequelize.literal('CURRENT_TIMESTAMP'),
      field: 'updateDate',
    },
    text1: {
      type: DataTypes.STRING(255),
      allowNull: true,
      defaultValue: '',
      field: 'text1',
    },
  },
  {
    tableName: 'forgot_status',
  });

  return taskStatus;
};
