'use strict';


module.exports = {
  success(data = false) {
    const method = this.request.method.toLowerCase();
    if (method === 'get') {
      this.status = 200;
      this.body = data || {};
    } else if (method === 'post') {
      this.status = 201;
      this.body = data || {};
    } else if (method === 'put' || method === 'delete') {
      this.status = data ? 200 : 204;
      this.body = data ? data : '';
    } else {
      this.status = 204;
      this.body = '';
    }
  },

  fail(error = '') {
    this.status = 400;
    this.body = {
      error,
    };
  },

  error(err = '') {
    this.status = 200;
    if (err.code === 'invalid_param') {
      this.body = { code: -1, msg: '请求参数有误' };
      return;
    }
    if (/[a-zA-Z]+/.test(err.message)) {
      this.body = { code: err.code || -1, msg: '系统错误, 请稍后再试' };
      return;
    }
    this.body = { code: err.code || -1, msg: err.message || '' };
  },

};
