'use strict';

const Controller = require('egg').Controller;

class ScriptController extends Controller {

  constructor(ctx) {
    super(ctx);
    this.helpRule = {
      id: {
        type: 'string',
        format: /^\d+$/,
      },
    };
  }

  // 获取城市配置
  async fetchCityConfig() {
    const { ctx, service } = this;
    try {
      const cityList = await service.scripts.fetchScriptList();
      ctx.body = cityList;
      return;
    } catch (err) {
      ctx.logger.error('fetchOrderId', err);
      ctx.error(err);
    }
  }

  async helpInfo() {
    const { ctx, service } = this;
    ctx.validate(this.helpRule, ctx.query);
    try {
      const id = ctx.query.id;
      const helpList = await service.scripts.fetchHelp(id);
      if (helpList.length > 0) {
        ctx.body = {
          code: 0,
          data: helpList[0].help_list,
        };
      } else {
        ctx.body = {
          code: 101,
          msg: '未查询到此地区帮助信息',
        };
        return;
      }
    } catch (err) {
      ctx.logger.error('helpInfo', err);
      ctx.error(err);
    }
  }
}

module.exports = ScriptController;
