'use strict';

const Service = require('egg').Service;

class StorageService extends Service {
  constructor(ctx) {
    super(ctx);
    const { config } = this;
    const { storageAPI } = config;
    this.baseURL = storageAPI.host;
    this.writeUrl = storageAPI.writeUrl;
    this.readUrl = storageAPI.readUrl;
    this.writeType = storageAPI.writeType;
    this.readDataKey = storageAPI.readDataKey;
  }

  _request(url, opts) {
    const { ctx, baseURL } = this;
    url = `${baseURL}${url}`;
    opts = {
      charset: 'utf-8',
      timeout: [30000, 30000],
      dataType: 'json',
      ...opts,
    };
    return ctx.curl(url, opts);
  }


  async write(data) {
    const { writeUrl, writeType, ctx } = this;
    const result = await this._request(writeUrl, {
      method: 'post',
      data: { ...data, serviceType: writeType },
      contentType: 'json',
    });

    ctx.logger.info(`【Storage】write url:${writeUrl} params`, JSON.stringify({ ...data, serviceType: writeType }), 'result:', JSON.stringify(result.data));
    if (result.data.code !== '0' || result.data.code !== 0) {
      throw new Error('存储数据出错');
    }
    return;
  }

  async read(orderId, appKey) {
    const { readUrl, readDataKey, ctx } = this;
    const result = await this._request(`${readUrl}/${orderId}`, {
      method: 'get',
      contentType: 'json',
    });
    ctx.logger.info(`【Storage】read url:${readUrl}/${orderId} write result:`, JSON.stringify(result.data));

    if (result && result.data && result.data.code !== 0) {
      ctx.logger.error(`storageAPI read ${readUrl}/${orderId}`, JSON.stringify(result.data));
      ctx.throw(400, { message: result.data.msg });
    }
    await ctx.model.Cusdata.create({
      appKey,
      orderId,
      type: 'gjj',
    });
    await ctx.nodemodel.Cusdata.create({
      appKey,
      orderSn: orderId,
      type: 'gjjAPI',
    });
    return result.data.data[readDataKey];
  }
}

module.exports = StorageService;
