'use strict';

const Controller = require('egg').Controller;

class TokenController extends Controller {
  constructor(ctx) {
    super(ctx);
    this.createRule = {
      sign: 'string',
      params: {
        type: 'object',
        rule: {
          appKey: 'string',
          timestamp: 'string',
        },
      },
    };
  }

  // 获取token
  async partnerCreate() {
    const { ctx, service } = this;
    try {
      ctx.validate(this.createRule);
      const token = await service.signature.createToken(ctx.request.body);
      ctx.body = {
        code: 0,
        data: { token },
        msg: '',
      };
    } catch (err) {
      ctx.logger.error('partnerCreate', err);
      ctx.status = 200;
      if (err.code === 'invalid_param') {
        ctx.body = { code: -1, msg: '请求参数有误' };
        return;
      }
      ctx.body = { code: err.code || -1, msg: err.message || '' };
    }
  }
}

module.exports = TokenController;
