'use strict';

const Service = require('egg').Service;

class PartnerService extends Service {
  constructor(ctx) {
    super(ctx);
    const { config: { partnerAPI } } = this;
    this.partnerAPI = partnerAPI;
  }

  async notice(order) {
    const { ctx } = this;
    const { orderId, notifyUrl, notice } = order;
    if (notifyUrl && notice !== '1') {
      const ret = await ctx.curl(notifyUrl, {
        charset: 'utf-8',
        timeout: ['30s', '30s'],
        contentType: 'json',
        method: 'POST',
        data: {
          orderSn: orderId,
        },
      }
      );
      ctx.logger.info(`【Partner】 notice ${notifyUrl}`, 'orderId:', orderId, 'result:', ret.status, JSON.stringify(ret.data));
      if (ret.status === 200) {
        await order.update({ notice: '1' });
      }
    }
    return;
  }
}

module.exports = PartnerService;
