'use strict';

const Service = require('egg').Service;

class PartnerService extends Service {

  async notice(order) {
    const { ctx } = this;
    const { orderId, notifyUrl, notice } = order;
    if (notifyUrl && notice !== '1') {
      const ret = await ctx.curl(notifyUrl, {
        charset: 'utf-8',
        timeout: [30000, 30000],
        contentType: 'json',
        method: 'POST',
        data: {
          orderSn: orderId,
        },
      }
      );
      ctx.logger.info(`【Partner】 notice ${notifyUrl}`, 'orderId:', orderId, 'result:', ret.status, JSON.stringify(ret.data));
      if (ret.status === 200) {
        await order.update({ notice: '1' });
      }
    } else {
      ctx.logger.info('【Partner】 notice no notifyUrl', 'orderId:', orderId);
    }
    return;
  }
}

module.exports = PartnerService;
