'use strict';

const Controller = require('egg').Controller;

class ScriptController extends Controller {

  async fetchCityConfig() {
    const { ctx, service } = this;
    try {
      const cityList = await service.scripts.fetchScriptList();
      ctx.body = cityList;
      return;
    } catch (err) {
      ctx.status = 200;
      if (err.code == 'invalid_param') {
        return ctx.body = { code: -1, message: err.message || '' };
      }
      return ctx.body = { code: err.code || -1, message: err.message || '' };
    }
  }
}

module.exports = ScriptController;
