'use strict';

const Service = require('egg').Service;

class WashDataService extends Service {
  constructor(ctx) {
    super(ctx);
    const { config } = this;
    this.washUrl = config.washAPI.host + config.washAPI.washUrl;
    this.clearGjj = ['ID', 'phone', 'birthday', 'email', 'address', 'card', 'deposit_base', 'person_rate', 'company_rate', 'marriage', 'sex', 'company_id'];
    this.clearLoan = ['name', 'ID', 'warning_rate', 'fund_date', 'bank', 'phone', 'address', 'past_due', 'past_principle', 'past_interest', 'past_period', 'history_past_period', 'history_past_amount', 'assure_style', 'house_type', 'debit_account', 'left_period'];
  }
  async wash(data) {
    const { app, washUrl, ctx } = this;
    const rawdata = this._switchData(data);
    const washData = await app.curl(washUrl,
      {
        charset: 'utf-8',
        timeout: [30000, 30000],
        dataType: 'json',
        data: rawdata,
        method: 'post',
        contentType: 'json',
      });
    if (washData.status !== 200) {
      ctx.logger.error(`【washData】url${washUrl} ,params`, rawdata, washData);
      throw new Error('清洗数据出错');
    }
    if (washData.data.code !== 0) {
      ctx.logger.error(`【washData】url${washUrl} ,params`, rawdata, washData.data);
      throw new Error('清洗数据出错');
    }
    washData.data.data.general_analyzed_data.overdueClassify = {};
    washData.data.data.general_analyzed_data.loanClassify = {};
    washData.data.data.general_analyzed_data.blacklist = {};

    return washData.data;
  }

  _switchData(data) {
    const tmp = data.data;
    const bar = {};
    bar.taskId = tmp.taskId;
    bar.cityId = tmp.cityId;
    bar.data = JSON.parse(tmp.data);
    bar.orderID = 'ttt';
    bar.appKey = '';
    return bar;
  }

  dealData(data, passID = false) {
    const { clearGjj, clearLoan } = this;
    delete data.data.general_analyzed_data;
    for (const gjjItem of data.data.gjj_data) {
      for (const text of clearGjj) {
        if (!(passID && text === 'ID')) {
          delete gjjItem.gjj_brief[text];
        }
      }
      delete gjjItem.gjj_account_analyzed_data;
    }
    for (const loanItem of data.data.loan_data) {
      for (const text of clearLoan) {
        delete loanItem.loan_brief[text];
      }
    }
    return data;
  }
}

module.exports = WashDataService;
