'use strict';

const Service = require('egg').Service;


class CacheService extends Service {
  constructor(ctx) {
    super(ctx);
    const { config } = this;
    const { taskPrefix } = config.lockKeys;
    this.taskPrefix = taskPrefix;
  }

  /**
   * 将orderId状态缓存到redis和数据库
   * @param {Object} key orderId
   *   - value: 状态 提示信息 status 、note={}
   *   - exprie: 过期时间
   */
  async set({ key, value = {}, exprie = 300 }) {
    const { ctx, app, taskPrefix } = this;

    const data = await app.redis.get(taskPrefix + key);
    if (!data || (data && data.status !== 'success')) {
      await app.redis.set(taskPrefix + key, JSON.stringify(value), 'EX', exprie);
    }

    const order = await ctx.model.TaskStatus.findOne({
      where: { orderId: key },
    });
    if (order && order.status !== 'success') {
      await order.update({ ...value });
    } else {
      ctx.logger.error('【Cache】set no order or already success', key);
    }
    ctx.logger.info(`【Cache】set ${key} value:`, JSON.stringify(value));
  }

  /**
   * 获取orderSn状态 优先redis
   * @param {Object} key orderSn
   * @return {Object} status note
   */

  async get({ key }) {
    const { ctx, app, taskPrefix } = this;
    const data = await app.redis.get(taskPrefix + key);
    if (data) {
      ctx.logger.info(`【Cache】get From redis ${key} data:`, data);
      return JSON.parse(data);
    }
    const order = await ctx.model.TaskStatus.findOne({
      where: { orderId: key },
    });
    if (order) {
      ctx.logger.info(`【Cache】get From Model ${key} order:`, JSON.stringify({ status: order.status, note: order.note }));
      return order;
    }
    ctx.logger.error(`【Cache】get No Result ${key} `);
    this.ctx.throw(400, { message: '无此订单号' });
  }
}

module.exports = CacheService;
