'use strict';

module.exports = () => {
  const config = exports = {};
  config.debug = true;

  config.logger = {
    dir: '/jianbing/logs/gjjapi',
  };

  config.projectRootPath = '/gjj_api';
  config.redis = {
    client: {
      port: 6379,
      host: process.env.REDIS_HOST,
      password: process.env.REDIS_PWD || 'DEV8redis',
      db: 0,
    },
  };

  config.JBnotifyCenter = {
    baseURL: 'https://notifier.getxumi.com/api/notify',
    settingid: '5cbef46823775d0001640fc8',
    appSecret: '6bc693e3ce84478482880a3600c9a78c',
  };
  config.taskAPI = {
    host: process.env.TASKAPI_HOST || 'http://tm.51gjj.com:4821',
    createTaskUrl: '/gjjServices/createGjjTask',
    fetchCodeUrl: '/gjjServices/queryGjjCode',
    submitTaskUrl: '/gjjServices/queryGjj',
    fetchTaskUrl: '/gjjServices/getGjjData',
  };

  config.scriptsAPI = {
    host: process.env.SCRIPTSAPI_HOST || 'https://uat-nginx.jianbing.com/zeus-api/v1',
    fetchScriptsUrl: '/chaos/hf/two_dimension_array/queries',
    fetchOneScriptUrl: '/chaos/hf/two_dimension_array/info',
    fetchParamsInfoUrl: '/chaos/hf/login_param_map',
    fetchQueryButtonUrl: '/chaos/hf/query_button',
    fetchHelpUrl: '/chaos/hf/help',
    fetchNoticeUrl: '/chaos/hf/notice',
    fetchHubSeriptsUrl: '/chaos/hf/hubs',
    fetchScriptByCityNameUrl: '/chaos/hf/city_scripts',
    redisScriptsKey: 'URANUS.HF.SCRIPTS',
    redisParamsKey: 'URANUS.HF.PARAMS',
    redisScriptListKey: 'URANUS.HF.SCRIPTLIST',
  };

  config.storageAPI = {
    host: process.env.STORAGEAPI_HOST || 'http://tv.51gjj.com:11252',
    writeUrl: '/data',
    readUrl: '/gjj',
    writeType: 'gjj',
    readDataKey: 'gjjData',
  };

  config.cityListAPI = process.env.TASKAPI_HOST + '/gjjServices/queryGjjCitySettings';

  config.washAPI = {
    host: process.env.WASHAPI_HOST || 'http://tt.51gjj.com:11007',
    washUrl: '/v2/gjj/analyzeGjj',
  };

  config.signatureAPI = {
    host: process.env.SIGNATUREAPI_HOST || 'http://tj3.51gjj.com:5118',
    fetchTokenUrl: '/Access/GetToken',
    fetchOrderIdUrl: '/Order/GetOrderSn',
    signatureUrl: '/Access/SignValidityCheck',
    fetchParnterUrl: '',
    signatureType: 'gjj',
    customerUrl: '/customer/query',
  };

  config.partnerAPI = {
    host: process.env.PARTNERAPI_HOST || 'https://uat-nginx.jianbing.com/zeus-api/v1',
    fetchTheme: '/chaos/hf/partners',
    fetchScripts: '/chaos/partners/scripts',
    redisappKeyLimitPrefix: 'URANUS.HF.PARNTERS.Limit',
  };

  config.lockKeys = {
    fecthHub: 'URANUS.HF.HUBS.LOCK',
    fecteToken: 'URANUS.HF.TOKEN.LOCK',
    token: 'URANUS.HF.TOKEN',
    fecthParnters: 'URANUS.PARNTERS.LOCK',
    taskPrefix: 'URANUS.HFH5.TASK',
  };

  config.sequelize = {
    datasources: [{
      // 东八时区
      timezone: '+08:00',
      delegate: 'nodemodel',
      baseDir: 'model/nodegjj',
      dialect: 'mysql',
      host: process.env.MYSQL_PACHONG_HOST || 'rds-jb-08.mysql.rds.aliyuncs.com',
      database: process.env.MYSQL_NODE_SERVER_DB_NAME || 'node_gjj',
      username: process.env.MYSQL_USER || 'hexin',
      password: process.env.MYSQL_PWD || 'gYUHszn9#q',
      port: process.env.MYSQL_PORT || 3306,
    }, {
      // 东八时区
      timezone: '+08:00',
      delegate: 'model',
      baseDir: 'model',
      dialect: 'mysql',
      host: process.env.MYSQL_PACHONG_HOST || 'rds-jb-08.mysql.rds.aliyuncs.com',
      database: process.env.MYSQL_DATA_SERVER_DB_NAME || 'data_service_pro',
      username: process.env.MYSQL_USER || 'hexin',
      password: process.env.MYSQL_PWD || 'gYUHszn9#q',
      port: process.env.MYSQL_PORT || 3306,
    }],
  };

  config.callbackUrl = process.env.CALLBACK_URL || 'https://dev-nginx.jianbing.com/gjj_api/callback';

  return config;
};
