'use strict';

module.exports = app => {
  const { DataTypes } = app.Sequelize;

  const gjjStatus = app.nodemodel.define('gjjStatus', {
    orderId: {
      type: DataTypes.STRING(255),
      allowNull: false,
      primaryKey: true,
      field: 'orderId',
    },
    taskId: {
      type: DataTypes.STRING(255),
      allowNull: false,
      defaultValue: '',
      field: 'taskId',
    },
    cityId: {
      type: DataTypes.STRING(10),
      allowNull: true,
      defaultValue: '',
      field: 'text1',
    },
    appkey: {
      type: DataTypes.STRING(50),
      allowNull: false,
      field: 'appkey',
    },
    notifyUrl: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: '',
      field: 'callbackUrl',
    },
    status: {
      type: DataTypes.STRING(20),
      allowNull: true,
      defaultValue: '',
      field: 'status',
    },
    note: {
      type: DataTypes.STRING(8000),
      allowNull: true,
      defaultValue: '',
      field: 'note',
      get() {
        const note = this.getDataValue('note');
        if (note) {
          try {
            return JSON.parse(note);
          } catch (error) {
            return {};
          }
        }
        return {};
      },
      set(val) {
        this.setDataValue('note', JSON.stringify(val));
      },
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: app.Sequelize.literal('CURRENT_TIMESTAMP'),
      field: 'createDate',
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: app.Sequelize.literal('CURRENT_TIMESTAMP'),
      field: 'updateDate',
    },
  },
  {
    tableName: 'gjj_status',
  });

  return gjjStatus;
};
