'use strict';

const Controller = require('egg').Controller;

class ScriptController extends Controller {

  //获取城市配置
  async fetchCityConfig() {
    const { ctx, service } = this;
    try {
      const cityList = await service.scripts.fetchScriptList();
      ctx.body = cityList;
      return;
    } catch (err) {
      ctx.logger.error('fetchOrderId', err);
      ctx.status = 200;
      if (err.code === 'invalid_param') {
        ctx.body = { code: -1, msg: err.message || '' };
        return;
      }
      if (/[a-zA-Z]+/.test(err.message)) {
        ctx.body = { code: err.code || -1, msg: '系统错误, 请稍后再试' };
        return;
      }
      ctx.body = { code: err.code || -1, msg: err.message || '' };
    }
  }
}

module.exports = ScriptController;
