'use strict';

/**
 * @param {Egg.Application} app - egg application
 */
module.exports = app => {
  const { router, controller } = app;

  const gjjRouter = router.namespace(app.config.projectRootPath);

  gjjRouter.post('/getToken', controller.token.partnerCreate);// 合作方创建token

  gjjRouter.post('/getOrderSn', controller.order.fetchOrderId);// 合作方获取订单号

  gjjRouter.get('/getCity', controller.script.fetchCityConfig);// 获取公积金城市基础配置项

  gjjRouter.post('/callback', controller.task.handleCallback); // 处理回调结果，不对外

  gjjRouter.get('/helpInfo', controller.script.helpInfo);// 获取帮助信息

  gjjRouter.post('/getCode', controller.task.fetchCapture);// 获取验证码

  gjjRouter.post('/query', controller.task.submit);// 提交任务查询参数

  gjjRouter.post('/getData', controller.order.partnerShow);// 合作方获取订单数据


};
