'use strict';

const Service = require('egg').Service;

class PartnerService extends Service {
  constructor(ctx) {
    super(ctx);
    const { config: { partnerAPI } } = this;
    this.partnerAPI = partnerAPI;
  }

  async fetchTheme(appKey) {
    const { ctx, partnerAPI: { fetchTheme, host, redisThemePrefix } } = this;
    if (appKey) {
      const data = await this.app.cache.get(redisThemePrefix + appKey);
      if (data) {
        try {
          return JSON.parse(data);
        } catch (err) {
          ctx.logger.error('【Scripts】fetchParams', redisThemePrefix + appKey, 'result:', data, err);
          await this.app.cache.del(redisThemePrefix + appKey);
        }
      }
    }
    const ret = await ctx.curl(`${host + fetchTheme}/${appKey}/theme`, {
      charset: 'utf-8',
      timeout: ['30s', '30s'],
      dataType: 'json',
      method: 'GET',
    });
    ctx.logger.info(`【Partner】 fetchTheme ${host + fetchTheme}/${appKey}`, ret.data);
    if (ret.status === 200 && ret.data && ret.data.appKey === appKey) {
      await this.app.cache.set(redisThemePrefix + appKey, JSON.stringify(ret.data), 300);
    }
    return ret.data;
  }

  async fetchScripts(appKey) {
    const { ctx, partnerAPI: { fetchScripts, host, redisScriptsPrefix } } = this;

    if (appKey) {
      const data = await this.app.cache.get(redisScriptsPrefix + appKey);
      if (data) {
        try {
          return JSON.parse(data);
        } catch (err) {
          ctx.logger.error('【Partner】 fetchScripts', redisScriptsPrefix + appKey, 'result:', JSON.stringify(data), err);
          await this.app.cache.del(redisScriptsPrefix + appKey);
        }
      }
    }
    const url = `${host + fetchScripts}/${appKey}`;
    const ret = await ctx.curl(url, {
      charset: 'utf-8',
      timeout: ['30s', '30s'],
      dataType: 'json',
      method: 'GET',
    });
    ctx.logger.info(`【Partner】 fetchTheme ${url}`, JSON.stringify(ret.data));
    if (ret.status === 200 && ret.data && ret.data.id === appKey) {
      await this.app.cache.set(redisScriptsPrefix + appKey, JSON.stringify(ret.data), 300);
    }
    return ret.data;
  }
  async fetchAgreements(id) {
    const { ctx, partnerAPI: { fetchAgreements, host, redisAgreementsPrefix } } = this;
    const data = await this.app.cache.get(redisAgreementsPrefix + id);
    if (data) {
      try {
        return JSON.parse(data);
      } catch (err) {
        ctx.logger.error('【Partner】 fetchAgreements', redisAgreementsPrefix + id, 'result:', JSON.stringify(data), err);
        await this.app.cache.del(redisAgreementsPrefix + id);
      }
    }
    const url = `${host + fetchAgreements}/${id}`;
    const ret = await ctx.curl(url, {
      charset: 'utf-8',
      timeout: ['30s', '30s'],
      dataType: 'json',
      method: 'GET',
    });
    ctx.logger.info(`【Partner】 fetchAgreements ${url}`, JSON.stringify(ret.data));
    if (ret.status === 200 && ret.data && ret.data.id === id) {
      await this.app.cache.set(redisScriptsPrefix + appKey, JSON.stringify(ret.data), 300);
    }
    return ret.data;
  }

  async notice(order) {
    const { ctx } = this;
    const { orderId, callbackUrl, userId, notice } = order;
    if (callbackUrl && notice !== '1') {
      const ret = await ctx.curl(callbackUrl, {
        charset: 'utf-8',
        timeout: ['30s', '30s'],
        contentType: 'json',
        method: 'POST',
        data: {
          orderId,
          userId,
          status: 'success'
        },
      }
      )
      ctx.logger.info(`【Partner】 notice ${callbackUrl}`, 'orderId:', orderId, 'result:', JSON.stringify(ret.data));
      await order.update({ notice: '1' });
    }
    return;
  }
}

module.exports = PartnerService;
