'use strict';

const Service = require('egg').Service;

class OrderService extends Service {
  async getOneByOrderId(orderId) {
    const { ctx } = this;
    const order = await ctx.model.TaskStatus.findOne({
      where: { orderId },
    });
    return order;
  }
  async getOneByTaskId(taskId) {
    const { ctx } = this;
    const order = await ctx.model.TaskStatus.findOne({
      where: { taskId },
    });
    return order;
  }

  async create(params) {
    const { ctx } = this;
    // const order = await ctx.model.TaskStatus.findOne({
    //   where: { orderId: params.orderId },
    // });
    // if (order) {
    //   ctx.throw(400, { message: 'already have order' });
    // }
    await ctx.model.TaskStatus.create(params);
    return;
  }

  async update(params) {
    const { ctx } = this;
    const order = await ctx.model.TaskStatus.findOne({
      where: { orderId: params.orderId },
    });
    if (!order) {
      ctx.throw(400, { message: 'no order' });
    }
    const { appKey, taskId, notifyUrl, backUrl, userId } = order;
    if (taskId) {
      if (params.userId) {
        await ctx.model.TaskStatus.create({ appKey, status: 'init', notifyUrl, backUrl, ...params })
      } else {
        await ctx.model.TaskStatus.create({ appKey, status: 'init', notifyUrl, backUrl, ...params, userId })
      }
    } else {
      await order.update(params);
    }
    return order;
  }
}

module.exports = OrderService;
