'use strict';

module.exports = app => {
  const { DataTypes } = app.Sequelize;

  const nodeLimit = app.model.define('nodeLimit', {
    id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      autoIncrement: true,
      primaryKey: true,
      field: 'id',
    },
    companyName: {
      type: DataTypes.STRING(255),
      allowNull: true,
      field: 'companyName',
    },
    appKey: {
      type: DataTypes.STRING(255),
      allowNull: false,
      field: 'appKey',
    },
    type: {
      type: DataTypes.STRING(255),
      allowNull: true,
      field: 'type',
    },
    currentCount: {
      type: DataTypes.INTEGER(20),
      allowNull: true,
      defaultValue: 0,
      field: 'currentCount',
    },
    limitCount: {
      type: DataTypes.INTEGER(20),
      allowNull: true,
      defaultValue: 0,
      field: 'limitCount',
    },
    createTime: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: app.Sequelize.literal('CURRENT_TIMESTAMP'),
      field: 'createTime',
    },
    updateTime: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: app.Sequelize.literal('CURRENT_TIMESTAMP'),
      field: 'updateTime',
    },
    text: {
      type: DataTypes.STRING(255),
      allowNull: true,
      field: 'text1',
    },
    text2: {
      type: DataTypes.STRING(255),
      allowNull: true,
      field: 'text2',
    },
  },
  {
    tableName: 'node_limit',
    timestamps: false,
  });

  return nodeLimit;
};
