/*
 * @Descripttion:
 * @version:
 * @Author: jd
 * @Date: 2019-02-25 18:59:53
 * @LastEditors  : jd
 * @LastEditTime : 2019-12-21 15:08:49
 */
'use strict';

const Service = require('egg').Service;


class CacheService extends Service {
  constructor(ctx) {
    super(ctx);
    const { config } = this;
    const { taskPrefix } = config.lockKeys;
    this.taskPrefix = taskPrefix;
  }

  /**
   * 将taskId状态缓存到redis和数据库
   * @param {Object} key taskId
   *   - value: 状态 提示信息 status 、note={}
   *   - exprie: 过期时间
   */
  async set({ key, value = {}, exprie = 300 }) {
    const { ctx, app, taskPrefix } = this;

    const data = await app.redis.get(taskPrefix + key);
    if (!data || (data && data.status !== 'success')) {
      await app.redis.set(taskPrefix + key, JSON.stringify(value), 'EX', exprie);
    }

    const order = await ctx.model.TaskStatus.findOne({
      attributes: ['id', 'appKey', 'status'],
      where: { taskId: key },
    });
    if (order && order.status !== 'success') {
      if (order.appKey === '3BA01E15AC6742E2883ADA4817840D5F' && value.status === 'login') {
        const ip = ctx.request.ip.split(',');
        const iplimit = await app.redis.get(ip);
        if (ip[0] !== '101.71.242.179' && ip[0] !== '122.224.130.226') {
          if (!iplimit) {
            await app.redis.set(ip, JSON.stringify({ count: 1 }), 'EX', 15 * 3600);
            ctx.logger.info(`ipLimit set ${ip[0]} value:`, 1);
          } else {
            const { count } = JSON.parse(iplimit);
            await app.redis.set(ip, JSON.stringify({ count: count + 1 }), 'EX', 15 * 3600);
            ctx.logger.info(`ipLimit ADD ${ip[0]} value:`, count + 1);
            if (count + 1 > 30) {
              ctx.logger.info(`ipLimit ${ip[0]} MAX30LIMIT 提交任务失败`);
              ctx.throw(400, { message: '提交任务失败' });
              return;
            }
          }
        }
      }
      await order.update({ ...value });
    } else {
      ctx.logger.error('【Cache】set no order or already success', key);
    }
    ctx.logger.info(`【Cache】set ${key} value:`, JSON.stringify(value));
  }

  /**
   * 获取task状态 优先redis
   * @param {Object} key taskId
   * @return {Object} status note
   */

  async get({ key }) {
    const { ctx, app, taskPrefix } = this;
    const data = await app.redis.get(taskPrefix + key);
    if (data) {
      ctx.logger.info(`【Cache】get From redis ${key} data:`, data);
      return JSON.parse(data);
    }
    const order = await ctx.model.TaskStatus.findOne({
      attributes: ['status', 'note'],
      where: { taskId: key },
    });
    if (order) {
      ctx.logger.info(`【Cache】get From Model ${key} order:`, JSON.stringify({ status: order.status, note: order.note }));
      return { status: order.status, note: order.note };
    }
    ctx.logger.error(`【Cache】get No Result ${key} `);
    this.ctx.throw(400, { message: 'no taskId' });
  }
}

module.exports = CacheService;
