'use strict';
const querystring = require('querystring');
const crypto = require('crypto');

function process(params) {
  const keys = Object.keys(params)
    .filter(key => {
      return (
        params[key] !== undefined &&
                params[key] !== '' &&
                ['appSecret', 'partner_key', 'sign', 'key'].indexOf(key) < 0
      );
    })
    .sort();
  const result = {};
  for (const key of keys) {
    result[key] = params[key];
  }
  return result;
}

module.exports.buildRequestBody = function(params, needNonceStr = false) {
  const { app } = this;
  const { appKey, appSecret } = app.config.GJJ_OpenAPI;
  params = params || {};
  params.appKey = appKey;
  params.timestamp = Date.now();
  if (needNonceStr) {
    params.nonce_str = this.genRandomStr(16);
  }
  const signStr = this.paramSign(appSecret, params);
  return { sign: signStr, params };
};

module.exports.genRandomStr = function(length) {
  return crypto.randomBytes(length).toString('hex');
};

module.exports.paramSign = function(appSecret, params) {
  if (!params) {
    const err = new Error('parameter params missing');
    err.name = 'ParameterSignError';
    throw err;
  }
  if (!appSecret) {
    const err = new Error('parameter appSecret missing');
    err.name = 'ParamSignError';
    throw err;
  }
  const newParams = process(params);
  let query = querystring.stringify(newParams);
  query += '&appSecret=' + appSecret;
  const signStr = crypto
    .createHash('md5')
    .update(query)
    .digest('hex')
    .toUpperCase();
  return signStr;
};
