'use strict';

const Service = require('egg').Service;

class PartnerService extends Service {
  constructor(ctx) {
    super(ctx);
    const { config: { partnerAPI } } = this;
    this.partnerAPI = partnerAPI;
  }

  async fetchTheme(appKey) {
    const { ctx, partnerAPI: { fetchTheme, host, redisThemePrefix } } = this;
    if (appKey) {
      const data = await this.app.cache.get(redisThemePrefix + appKey);
      if (data) {
        try {
          return JSON.parse(data);
        } catch (err) {
          ctx.logger.error('【Scripts】fetchParams', redisThemePrefix + appKey, 'result:', data, err);
          await this.app.cache.del(redisThemePrefix + appKey);
        }
      }
    }
    const ret = await ctx.curl(`${host + fetchTheme}/${appKey}`, {
      charset: 'utf-8',
      timeout: ['30s', '30s'],
      dataType: 'json',
      method: 'GET',
    });
    ctx.logger.info(`【Partner】 fetchTheme ${host + fetchTheme}/${appKey}`, ret.data);
    if (ret.status === 200 && ret.data && ret.data.id === appKey) {
      await this.app.cache.set(redisThemePrefix + appKey, JSON.stringify(ret.data), 'EX', 7200);
    }
    return ret.data;
  }

  async fetchScripts(appKey) {
    const { ctx, partnerAPI: { fetchScripts, host, redisScriptsPrefix } } = this;

    if (appKey) {
      const data = await this.app.cache.get(redisScriptsPrefix + appKey);
      if (data) {
        try {
          return JSON.parse(data);
        } catch (err) {
          ctx.logger.error('【Partner】 fetchScripts', redisScriptsPrefix + appKey, 'result:', data, err);
          await this.app.cache.del(redisScriptsPrefix + appKey);
        }
      }
    }
    const url = `${host + fetchScripts}/${appKey}`;
    const ret = await ctx.curl(url, {
      charset: 'utf-8',
      timeout: ['30s', '30s'],
      dataType: 'json',
      method: 'GET',
    });
    ctx.logger.info(`【Partner】 fetchTheme ${url}`, ret.data);
    if (ret.status === 200 && ret.data && ret.data.id === appKey) {
      await this.app.cache.set(redisScriptsPrefix + appKey, JSON.stringify(ret.data), 'EX', 7200);
    }
    return ret.data;
  }
}

module.exports = PartnerService;
