'use strict';

module.exports = app => {
    const { DataTypes } = app.Sequelize;

    const cusDatas = app.model.define('cusDatas', {
        id: {
            type: DataTypes.INTEGER,
            allowNull: false,
            autoIncrement: true,
            primaryKey: true,
            field: 'id',
        },
        orderId: {
            type: DataTypes.STRING(255),
            allowNull: false,
            defaultValue: '',
            primaryKey: true,
            field: 'orderId',
        },
        appKey: {
            type: DataTypes.STRING(255),
            allowNull: false,
            field: 'appKey',
        },
        type: {
            type: DataTypes.STRING(255),
            allowNull: true,
            defaultValue: '',
            field: 'type',
        },
        date: {
            type: DataTypes.DATE,
            allowNull: true,
            defaultValue: app.Sequelize.literal('CURRENT_TIMESTAMP'),
            field: 'date',
        },
        text1: {
            type: DataTypes.STRING(255),
            allowNull: true,
            defaultValue: '',
            field: 'text1',
        },
        text2: {
            type: DataTypes.STRING(255),
            allowNull: true,
            defaultValue: '',
            field: 'text2',
        },
        text3: {
            type: DataTypes.STRING(255),
            allowNull: true,
            defaultValue: '',
            field: 'text3',
        },
        text4: {
            type: DataTypes.STRING(255),
            allowNull: true,
            defaultValue: '',
            field: 'text4',
        },
        date1: {
            type: DataTypes.DATE,
            allowNull: true,
            defaultValue: app.Sequelize.literal('CURRENT_TIMESTAMP'),
            field: 'date1',
        },
        date2: {
            type: DataTypes.DATE,
            allowNull: true,
            defaultValue: app.Sequelize.literal('CURRENT_TIMESTAMP'),
            field: 'date2',
        },
    },
        {
            tableName: 'cus_data',
            timestamps: false,
        });

    return cusDatas;
}