'use strict';

const Controller = require('egg').Controller;

class ScriptController extends Controller {
  async fetchScripts() {
    const { ctx, service } = this;
    const { appKey } = ctx.query;
    let limitScriptsList = false;
    if (appKey) {
      const ret = await service.partner.fetchScripts(appKey);
      limitScriptsList = ret.scripts;
    }
    let data = await service.scripts.fetchScripts();
    if (limitScriptsList) {
      data = data.filter(item => {
        return limitScriptsList.includes(item.id);
      });
    }
    ctx.success(data);
  }

  async fetchOneScripts() {
    const { ctx, service } = this;
    let { scriptId } = ctx.params;
    if (scriptId === 'auto') {
      const ret = await service.scripts.fetchScriptIdByIp();
      scriptId = ret.scriptId;
    }
    const data = await service.scripts.fetchOneScripts(scriptId);
    ctx.success(data);
  }
  async fetchParamsInfo() {
    const { ctx, service } = this;
    const { refresh = false } = ctx.query;
    const data = await service.scripts.fetchParams(refresh);
    ctx.success(data);
  }

  async fetchHelpInfo() {
    const { ctx, service } = this;
    const { scriptId } = ctx.params;
    const data = await service.scripts.fetchHelp(scriptId);
    ctx.success(data);
  }

  async fetchQueryButtonInfo() {
    const { ctx, service } = this;
    const { scriptId } = ctx.params;
    const data = await service.scripts.fetchQueryButton(scriptId);
    ctx.success(data);
  }

  async fetchNoticeInfo() {
    const { ctx, service } = this;
    const { scriptId } = ctx.params;
    const data = await service.scripts.fetchNotice(scriptId);
    ctx.success(data);
  }

  async fetchHubSeripts() {
    const { ctx, service } = this;
    let { hubId } = ctx.params;
    if (hubId === 'auto') {
      const ret = await service.scripts.fetchScriptIdByIp();
      hubId = ret.hubId;
    }
    const data = await service.scripts.fetchHubSeripts(hubId);
    ctx.success(data);
  }
}

module.exports = ScriptController;
