'use strict';

module.exports = app => {
  const { DataTypes } = app.Sequelize;

  const taskStatsu = app.model.define('taskStatsu', {
    id:{
      type:DataTypes.INTEGER,
      allowNull: false,
      autoIncrement: true,
      primaryKey: true,
      field: 'id',
    },
    orderId: {
      type: DataTypes.STRING(255),
      allowNull: false,
      defaultValue: '',
      primaryKey: true,
      field: 'orderId',
    },
    taskId: {
      type: DataTypes.STRING(255),
      allowNull: false,
      defaultValue: '',
      field: 'taskId',
    },
    userId: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: '',
      field: 'userId',
    },
    cityId: {
      type: DataTypes.STRING(255),
      allowNull: true,
      defaultValue: '',
      field: 'cityId',
    },
    appKey: {
      type: DataTypes.STRING(255),
      allowNull: false,
      field: 'appKey',
    },
    callbackUrl: {
      type: DataTypes.STRING(255),
      allowNull: false,
      defaultValue: '',
      field: 'callbackUrl',
    },
    status: {
      type: DataTypes.STRING(255),
      allowNull: true,
      defaultValue: '',
      field: 'status',
    },
    note: {
      type: DataTypes.STRING(8000),
      allowNull: true,
      defaultValue: '',
      field: 'note',
      get() {
        const note = this.getDataValue('note');
        if (note) {
          try {
            return JSON.parse(note);
          } catch (error) {
            return {};
          }
        }
        return {};
      },
      set(val) {
        this.setDataValue('note', JSON.stringify(val));
      },
    },
    createDate: {
      type: DataTypes.DATE,
      allowNull: true,
      primaryKey: true,
      defaultValue: app.Sequelize.literal('CURRENT_TIMESTAMP'),
      field: 'createDate',
    },
    updateDate: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: app.Sequelize.literal('CURRENT_TIMESTAMP'),
      primaryKey: true,
      field: 'updateDate',
    },
  }, {
    tableName: 'gjj_status',
    timestamps: false,
  });

  return taskStatsu;
};
