'use strict';

const Controller = require('egg').Controller;

class TokenController extends Controller {
  constructor(ctx) {
    super(ctx);
    this.createRule = {
      sign: 'string',
      params: {
        type: 'object',
        rule: {
          appKey: 'string',
          timestamp: 'string',
        },
      },
    };
  }
  async create() {
    const { ctx, service } = this;
    ctx.validate(this.createRule);
    const token = await service.signature.createToken(ctx.request.body);
    ctx.success({ data: token });
  }

  async partnerCreate() {
    const { ctx, service } = this;
    try {
      ctx.validate(this.createRule);
    } catch (err) {
      ctx.logger.info(JSON.stringify(err));
      return ctx.body = { code: -1, message: err.message };
    }
    try {
      const token = await service.signature.createToken(ctx.request.body);
      return ctx.body = {
        code: 0,
        data: { token },
        message: ''
      }
    } catch (err) {
      ctx.status = 200;
      return ctx.body = { code: err.code || -1, message: err.message || '' };
    }
  }
}

module.exports = TokenController;
