'use strict';

/**
 * @param {Egg.Application} app - egg application
 */
module.exports = app => {
  const { router, controller } = app;


  router.post('/tasks', controller.task.create); // 创建任务
  router.get('/tasks/:taskId', controller.task.show); // 获取任务状态
  router.post('/tasks/:taskId/submit', controller.task.submit); // 提交任务参数
  router.post('/tasks/:taskId/capture', controller.task.fetchCapture); // 获取验证码

  router.post('/callback', controller.task.handleCallback); // 处理回调结果，不对外

  router.get('/scripts', controller.script.fetchScripts); // 获取所有脚本信息
  router.get('/scripts/:scriptId', controller.script.fetchOneScripts); // 获取单一脚本信息

  router.get('/help/:scriptId', controller.script.fetchHelpInfo); // 获取帮助信息
  router.get('/notice/:scriptId', controller.script.fetchNoticeInfo);// 获取提示信息
  router.get('/query_button/:scriptId', controller.script.fetchQueryButtonInfo); // 获取查询按钮信息

  router.get('/params', controller.script.fetchParamsInfo); // 获取登录参数字典
  router.post('/tokens', controller.token.create); // 创建token
  router.post('/orders', controller.order.create); // 创建订单号
  // router.post('/orders/:orderId', controller.order.show); // 获取订单号详情


  router.get('/hubs/:hubId/scripts', controller.script.fetchHubSeripts);// 根据hubId 获取脚本数据（数组）

  router.get('/theme/:appKey', controller.partner.show);// 根据hubId 获取脚本数据（数组）

  router.post('/getToken', controller.token.partnerCreate);// 合作方创建token

  router.post('/getdata',  controller.order.partnerShow);// 合作方获取订单数据

  router.post('/getCityConfig', controller.task.fetchCityConfig)//获取城市配置

  // 这个接口之后会移除掉
  // router.get('/orders', controller.order.fetchOrderId);

};
