'use strict';

const Service = require('egg').Service;

class StorageService extends Service {
  constructor(ctx) {
    super(ctx);
    const { config } = this;
    const { storageAPI } = config;
    this.baseURL = storageAPI.host;
    this.writeUrl = storageAPI.writeUrl;
    this.readUrl = storageAPI.readUrl;
    this.writeType = storageAPI.writeType;
    this.readDataKey = storageAPI.readDataKey;
  }

  _request(url, opts) {
    const { ctx, baseURL } = this;
    url = `${baseURL}${url}`;
    opts = {
      charset: 'utf-8',
      timeout: [30000, 30000],
      dataType: 'json',
      ...opts,
    };
    ctx.logger.info(`【StorageService】${url}`);
    return ctx.curl(url, opts);
  }


  async write(data) {
    const { writeUrl, writeType, ctx } = this;
    const result = await this._request(writeUrl, {
      method: 'post',
      data: { ...data, serviceType: writeType },
      contentType: 'json',
    });

    ctx.logger.info('【Storage】write result', JSON.stringify(result.data));
    if (result.status !== 200 || +result.data.code !== 0) {
      throw new Error('存储数据出错');
    }
    if (!(result.data.code !== '0' || result.data.code !== 0)) {
      throw new Error('存储数据出错');
    }
    return;
  }

  async read(orderId, appKey) {
    const { readUrl, readDataKey, ctx } = this;
    const result = await this._request(`${readUrl}${orderId}`, {
      method: 'get',
      contentType: 'json',
    });
    ctx.logger.info(`【Storage】read url:${readUrl}${orderId} write result:`, JSON.stringify(result.data));

    if (result && result.data && result.data.code !== 0) {
      ctx.logger.error(`storageAPI read ${readUrl}${orderId}`, JSON.stringify(result.data));
      ctx.throw(400, { message: result.data.msg });
    }
    await ctx.model.Cusdata.create({
      appKey,
      orderId,
      type: 'gjjH5',
    });
    await ctx.nodemodel.Cusdata.create({
      appkey: appKey,
      orderSn: orderId,
      type: 'gjjH5',
    });
    return result.data.data[readDataKey];
  }
}

module.exports = StorageService;
