/*
 * @Descripttion: 
 * @version: 
 * @Author: jd
 * @Date: 2019-02-25 18:59:53
 * @LastEditors: jd
 * @LastEditTime: 2019-10-31 15:05:26
 */
'use strict';

const Controller = require('egg').Controller;

class OrderController extends Controller {
  constructor(ctx) {
    super(ctx);
    this.createRule = {
      appKey: 'string',
      userId: {
        type: 'string',
        required: false,
      },
      orderId: {
        type: 'string',
        required: false,
        format: /^(\w{8})-(\w{4})-(\w{4})-(\w{4})-(\w{12})$/,
        message: '订单号格式错误',
      },
    };

    this.showRule = {
      sign: 'string',
      params: {
        type: 'object',
        rule: {
          token: 'string',
          orderId: {
            type: 'string',
            required: false,
          },
          orderSn: {
            type: 'string',
            required: false,
          },
          appKey: 'string',
          timestamp: 'string',
        },
      },
    };

    this.fetchRule = {
      sign: 'string',
      params: {
        type: 'object',
        rule: {
          appKey: 'string',
          timestamp: 'string',
          token: 'string',
        },
      },
    };
  }

  async create() {
    const { ctx, service } = this;
    ctx.validate(this.createRule);
    const { appKey, userId, notifyUrl, backUrl, orderId } = ctx.request.body;
    const appKeyInfo = await service.partner.fetchInfo(appKey);
    if (!(appKeyInfo && appKeyInfo.valid === true && appKeyInfo.enableHf === true)) {
      return ctx.fail('未开通此服务');
    }
    const object = {
      orderId,
      taskId: '',
      userId: userId || '',
      cityId: '',
      notifyUrl: notifyUrl || (ctx.app.notifyMap && ctx.app.notifyMap.get(appKey) && ctx.app.notifyMap.get(appKey).notifyUrl) || '',
      backUrl: backUrl || '',
      appKey,
      status: 'init',
    };
    if (orderId) {
      await service.order.update(object);
    } else {
      if (!userId) {
        ctx.throw(422, { message: '请输入userId' });
        return;
      }
      object.orderId = ctx.helper.getUuid();
      await service.order.create(object);
    }
    ctx.success({ orderId: object.orderId });
  }

  async partnerShow() {
    const { ctx, service } = this;
    try {
      ctx.validate(this.showRule);
      let { appKey, orderId, orderSn } = ctx.request.body.params;
      orderId = orderId || orderSn;
      const appKeyInfo = await service.partner.fetchInfo(appKey);
      if (!(appKeyInfo && appKeyInfo.valid === true && appKeyInfo.enableHfData === true)) {
        return ctx.fail('未开通此服务');
      }
      await service.signature.signatureCheck(ctx.request.body);
      const data = await service.order.getOneByOrderId({ orderId, status: 'success' });
      if (data) {
        await service.partner.appKeyLimit(appKey);
        const result = await service.storage.read(orderId, appKey);
        ctx.body = {
          code: 0,
          data: result,
        };
        return;
      }
      ctx.body = {
        code: -1,
        msg: '无此订单号',
      };
    } catch (err) {
      ctx.logger.error('partnerShow', JSON.stringify(err));
      ctx.error(err);
    }
  }

  async partnerGjjShow() {
    const { ctx, service } = this;
    try {
      ctx.validate(this.showRule);
      let { appKey, orderId, orderSn } = ctx.request.body.params;
      orderId = orderId || orderSn;
      const appKeyInfo = await service.partner.fetchInfo(appKey);
      if (!(appKeyInfo && appKeyInfo.valid === true && appKeyInfo.enableHfData === true)) {
        return ctx.fail('未开通此服务');
      }
      await service.signature.signatureCheck(ctx.request.body);
      const data = await service.order.getOneByOrderId({ orderId, status: 'success' });
      if (data) {
        await service.partner.appKeyLimit(appKey);
        const result = await service.storage.read(orderId, appKey);
        if((appKey === '49B580DEDF9E419CA0164C421331B89E' || appKey === '81B48E83FA9B4D18B7214552FD918253' || appKey === '6CF690AAD0F14410BDC064BE11BA07FC' || appKey === '80E7489823C94B228EA81221A0FFC8C7') && result.cityName === '郑州'){
          for(let item of result.data.gjj_data){
            item.gjj_account_analyzed_data.cont_last_times = 12
          }
        }
        ctx.body = {
          code: 0,
          data: {
            gjjData: result,
          },
        };
        return;
      }
      ctx.body = {
        code: -1,
        msg: '无此订单号',
      };
    } catch (err) {
      ctx.logger.error('partnerShow', JSON.stringify(err));
      ctx.error(err);
    }
  }

  async orderShow() {
    const { ctx, service } = this;
    const { appKey, orderId } = ctx.params;
    const appKeyInfo = await service.partner.fetchInfo(appKey);
    if (!(appKeyInfo && appKeyInfo.valid === true && appKeyInfo.enableHfView === true)) {
      return ctx.fail('未开通此服务');
    }
    const data = await service.order.getOneByOrderId({ orderId, status: 'success' });
    if (data) {
      await service.partner.appKeyLimit(appKey);
      if (data.status === 'success' && (data.appKey === appKey)) {
        const result = await service.storage.read(orderId, appKey);
        const ret = service.washData.dealData(result);
        ctx.success(ret);
        return;
      }
    }
    ctx.fail('无此订单号');
  }

  async fetchOrderId() {
    const { ctx, service } = this;
    try {
      ctx.validate(this.fetchRule);
      const { appKey } = ctx.request.body.params;
      const orderId = await service.signature.createOrderId(ctx.request.body);
      await service.order.create({
        orderId,
        taskId: '',
        cityId: '',
        notifyUrl: ctx.app.notifyMap.get(appKey) && ctx.app.notifyMap.get(appKey).notifyUrl || '',
        appKey,
        status: 'init',
      });
      ctx.body = {
        code: 0,
        data: {
          orderSn: orderId,
        },
        msg: '',
      };
    } catch (err) {
      ctx.logger.error('fetchOrderId', JSON.stringify(err));
      ctx.error(err);
    }
  }
}

module.exports = OrderController;
