/*
 * @Descripttion:
 * @version:
 * @Author: jd
 * @Date: 2019-02-25 18:59:53
 * @LastEditors  : jd
 * @LastEditTime : 2019-12-25 11:00:32
 */
'use strict';

const Service = require('egg').Service;

class TaskService extends Service {
  constructor(ctx) {
    super(ctx);
    const { config: { taskAPI, LOCK_KEY, ipLimitNum, ipwhite } } = this;
    this.taskAPI = taskAPI;
    this.baseURL = taskAPI.host;
    this.citylistURL = taskAPI.citylist;
    this.LOCK_KEY = LOCK_KEY;
    this.ipLimitNum = ipLimitNum;
    this.ipwhite = ipwhite;
  }


  _request(url, opts) {
    const { ctx, baseURL } = this;
    url = `${baseURL}${url}`;
    opts = {
      charset: 'utf-8',
      timeout: [30000, 30000],
      dataType: 'json',
      ...opts,
    };
    return ctx.curl(url, opts);
  }

  _checkSuccess(result) {
    if (result.status !== 200) {
      const errorMsg = result.data && result.data.error_msg ? result.data.error_msg : 'unknown error';
      this.ctx.throw(result.status, errorMsg);
    }
    if (result.data.code !== 0) {
      this.ctx.throw(400, { message: result.data.msg || result.data.data.img, code: result.data.code || -1 });
    }
  }
  async create(data) {
    const { ctx, taskAPI } = this;
    const { createTaskUrl } = taskAPI;
    const result = await this._request(createTaskUrl, {
      method: 'post',
      data: { cityId: data },
      contentType: 'json',
    });
    ctx.logger.info(`【Task】create ${createTaskUrl} cityId: ${data} result:`, JSON.stringify(result.data));
    this._checkSuccess(result);
    return result.data.data.taskId;
  }

  async fetchCapture({ taskId, type }) {
    const { taskAPI, ctx } = this;
    const { fetchCodeUrl, fetchPhoneCodeUrl } = taskAPI;
    let url = fetchCodeUrl;
    if (type == 'phone_code') {
      url = fetchPhoneCodeUrl;
    }
    const result = await this._request(url, {
      method: 'post',
      data: {
        taskId,
        type,
      },
      contentType: 'json',
    });
    ctx.logger.info(`【Task】fetchCapture ${fetchCodeUrl} params`, JSON.stringify({
      taskId,
      type,
    }), JSON.stringify(result.data));
    this._checkSuccess(result);
    return result.data.data;
  }
  async submit(data) {
    const { taskAPI, ctx } = this;
    const { submitTaskUrl } = taskAPI;
    const result = await this._request(submitTaskUrl, {
      method: 'post',
      data,
      contentType: 'json',
    });
    ctx.logger.info(`【Task】submit ${submitTaskUrl} params`, JSON.stringify(data), JSON.stringify(result.data));
    this._checkSuccess(result);
    return result;
  }
  async fetchTask(data) {
    const { taskAPI, ctx } = this;
    const { fetchTaskUrl } = taskAPI;
    const result = await this._request(fetchTaskUrl, {
      method: 'post',
      data,
      contentType: 'json',
    });
    ctx.logger.info(`【Task】fetchTask ${fetchTaskUrl} params`, JSON.stringify(data), result.data.code);
    return result.data;
  }
  async iplimit() {
    const { ctx, app, ipLimitNum, ipwhite } = this;
    const ip = ctx.request.ip.split(',');
    if (!ipwhite.includes(ip[0])) {
      const iplimit = await app.redis.get(ip[0]);
      if (iplimit) {
        const { count } = JSON.parse(iplimit);
        await app.redis.set(ip[0], JSON.stringify({ count }), 'EX', 15 * 3600);
        ctx.logger.info(`ipLimit ADD ${ip[0]} value:`, count);
        if (count + 1 > ipLimitNum) {
          ctx.logger.info(`ipLimit ${ip[0]} MAXLIMIT 创建任务失败`);
          ctx.throw(400, { message: '创建任务失败' });
          return;
        }
      }
    }
  }

}

module.exports = TaskService;
