'use strict';
module.exports = (options, app) => {
  return async function(ctx, next) {
    const { request } = ctx;
    const { header } = request;
    const ipStr = header['x-real-ip'] || header['x-forwarded-for'];
    if (ipStr) {
      request.ip = ipStr;
    }
    const start = new Date();
    let ms = 0;
    await next();
    ms = new Date() - start;
    app.logger.info(
      `[middleware-response-time](${ms}ms) ${request.method} ${request.protocol}://${request.ip}${
        request.originalUrl
      } ${ctx.response.status}`
    );
  };
};
