'use strict';

const Service = require('egg').Service;

class TaskService extends Service {
  constructor(ctx) {
    super(ctx);
    const { config: { taskAPI, LOCK_KEY } } = this;
    this.taskAPI = taskAPI;
    this.baseURL = taskAPI.host;
    this.citylistURL = taskAPI.citylist;
    this.LOCK_KEY = LOCK_KEY;
  }


  _request(url, opts) {
    const { ctx, baseURL } = this;
    url = `${baseURL}${url}`;
    opts = {
      charset: 'utf-8',
      timeout: ['30s', '30s'],
      dataType: 'json',
      ...opts,
    };
    return ctx.curl(url, opts);
  }

  _checkSuccess(result) {
    if (result.status !== 200) {
      const errorMsg = result.data && result.data.error_msg ? result.data.error_msg : 'unknown error';
      this.ctx.throw(result.status, errorMsg);
    }
    if (result.data.code !== 0) {
      this.ctx.throw(400, { message: result.data.msg || result.data.data.img, code: result.data.code || -1 });
    }
  }
  async create(data) {
    const { ctx, taskAPI } = this;
    const { createTaskUrl } = taskAPI;
    const result = await this._request(createTaskUrl, {
      method: 'post',
      data: { cityId: data },
      contentType: 'json',
    });
    ctx.logger.info(`【Task】create ${createTaskUrl} cityId: ${data} result:`, result.data);
    this._checkSuccess(result);
    return result.data.data.taskId;
  }

  async fetchCapture({ taskId, type }) {
    const { taskAPI, ctx } = this;
    const { fetchCodeUrl } = taskAPI;
    const result = await this._request(fetchCodeUrl, {
      method: 'post',
      data: {
        taskId,
        type,
      },
      contentType: 'json',
    });
    ctx.logger.info(`【Task】fetchCapture ${fetchCodeUrl} params`, {
      taskId,
      type,
    }, result.data);
    this._checkSuccess(result);
    return result.data.data;
  }
  async submit(data) {
    const { taskAPI, ctx } = this;
    const { submitTaskUrl } = taskAPI;
    const result = await this._request(submitTaskUrl, {
      method: 'post',
      data,
      contentType: 'json',
    });
    ctx.logger.info(`【Task】submit ${submitTaskUrl} params`, data, result.data);
    this._checkSuccess(result);
    return result;
  }
  async fetchTask(data) {
    const { taskAPI, ctx } = this;
    const { fetchTaskUrl } = taskAPI;
    const result = await this._request(fetchTaskUrl, {
      method: 'post',
      data,
      contentType: 'json',
    });
    ctx.logger.info(`【Task】fetchTask ${fetchTaskUrl} params`, data, result.data);
    return result.data;
  }

  async getCityList(){

  }

}

module.exports = TaskService;
