'use strict';

const Controller = require('egg').Controller;

class PartnerController extends Controller {
  //   constructor(ctx) {
  //     super(ctx);

  //   }

  async show() {
    const { ctx, service } = this;
    const { appKey } = ctx.params;
    const ret = await service.partner.fetchTheme(appKey);
    if (ret && ret.appKey === appKey) {
      ctx.success(ret);
      return;
    }
    ctx.fail('尚未配置主题');
  }

  async fetchAgreements() {
    const { ctx, service } = this;
    const { id } = ctx.params;
    const ret = await service.partner.fetchAgreements(id);
    if (ret && String(ret.id) === id) {
      ctx.success(ret);
      return;
    }
    ctx.fail('未获取到协议');
  }
}



module.exports = PartnerController;
