'use strict';

const Controller = require('egg').Controller;

class TokenController extends Controller {
  constructor(ctx) {
    super(ctx);
    this.createRule = {
      sign: 'string',
      params: {
        type: 'object',
        rule: {
          appKey: 'string',
          timestamp: 'string',
        },
      },
    };
  }
  async create() {
    const { ctx, service } = this;
    ctx.validate(this.createRule);
    const token = await service.signature.createToken(ctx.request.body);
    ctx.success({ data: token });
  }

  async partnerCreate() {
    const { ctx, service } = this;
    try {
      ctx.validate(this.createRule);
      const token = await service.signature.createToken(ctx.request.body);
      return ctx.body = {
        code: 0,
        data: { token },
        msg: ''
      }
    } catch (err) {
      ctx.logger.error('partnerCreate', JSON.stringify(err));
      ctx.status = 200;
      if (err.code == 'invalid_param') {
        return ctx.body = { code: -1, msg: err.message || '' };
      }
      return ctx.body = { code: err.code || -1, msg: err.message || '' };
    }
  }
}

module.exports = TokenController;
