'use strict';

const Service = require('egg').Service;

class PartnerService extends Service {
  constructor(ctx) {
    super(ctx);
    const { config: { partnerAPI } } = this;
    this.partnerAPI = partnerAPI;
  }

  async fetchTheme(appKey) {
    const { ctx, partnerAPI: { fetchTheme, host, redisThemePrefix } } = this;
    if (appKey) {
      const data = await this.app.redis.get(redisThemePrefix + appKey);
      if (data) {
        try {
          return JSON.parse(data);
        } catch (err) {
          ctx.logger.error('【Scripts】fetchParams', redisThemePrefix + appKey, 'result:', data, err);
          await this.app.redis.del(redisThemePrefix + appKey);
        }
      }
    }
    const ret = await ctx.curl(`${host + fetchTheme}`, {
      charset: 'utf-8',
      timeout: [30000, 30000],
      dataType: 'json',
      method: 'GET',
      data: {
        appKey,
        subject: 'hf',
      },
    });
    ctx.logger.info(`【Partner】 fetchTheme ${host + fetchTheme}/${appKey}`, ret.data);
    if (ret.status === 200 && ret.data && ret.data.length > 0 && ret.data[0].appKey === appKey) {
      await this.app.redis.set(redisThemePrefix + appKey, JSON.stringify(ret.data[0]), 'EX', 300);
    }
    return ret.data[0];
  }

  async fetchInfo(appKey) {
    const { ctx, partnerAPI: { fetchInfo, host, redisInfoPrefix } } = this;
    if (appKey) {
      const data = await this.app.redis.get(redisInfoPrefix + appKey);
      if (data) {
        try {
          return JSON.parse(data);
        } catch (err) {
          ctx.logger.error('【Scripts】fetchInfo', redisInfoPrefix + appKey, 'result:', data, err);
          await this.app.redis.del(redisInfoPrefix + appKey);
        }
      }
    }
    const ret = await ctx.curl(`${host + fetchInfo}`, {
      charset: 'utf-8',
      timeout: [30000, 30000],
      dataType: 'json',
      method: 'GET',
      data: {
        appKey,
      },
    });
    ctx.logger.info(`【Partner】 fetchTheme ${host + fetchInfo}?appKey=${appKey}`, ret.data);
    if (ret.status === 200 && ret.data && ret.data.length > 0 && ret.data[0].appKey === appKey) {
      await this.app.redis.set(redisInfoPrefix + appKey, JSON.stringify(ret.data[0]), 'EX', 300);
    }
    return ret.data[0];
  }

  async fetchAgreements(id) {
    const { ctx, partnerAPI: { fetchAgreements, host, redisAgreementsPrefix } } = this;
    const data = await this.app.redis.get(redisAgreementsPrefix + id);
    if (data) {
      try {
        return JSON.parse(data);
      } catch (err) {
        ctx.logger.error('【Partner】 fetchAgreements', redisAgreementsPrefix + id, 'result:', JSON.stringify(data), err);
        await this.app.redis.del(redisAgreementsPrefix + id);
      }
    }
    const url = `${host + fetchAgreements}/${id}`;
    const ret = await ctx.curl(url, {
      charset: 'utf-8',
      timeout: [30000, 30000],
      dataType: 'json',
      method: 'GET',
    });
    ctx.logger.info(`【Partner】 fetchAgreements ${url}`, JSON.stringify(ret.data));
    if (ret.status === 200 && ret.data && ret.data.id === id) {
      await this.app.redis.set(redisAgreementsPrefix + id, JSON.stringify(ret.data), 'EX', 300);
    }
    return ret.data;
  }

  async notice(order) {
    const { ctx, service } = this;
    const { orderId, notifyUrl, userId, notice } = order;
    const dbRes = await service.order.getOneByOrderId({ orderId, notice: 1 });
    if (!dbRes && notifyUrl && notice !== '1') {
      const ret = await ctx.curl(notifyUrl, {
        charset: 'utf-8',
        timeout: [30000, 30000],
        contentType: 'json',
        method: 'POST',
        data: {
          order_id: orderId,
          user_id: userId || '',
          status: 'success',
        },
      }
      );
      ctx.logger.info(`【Partner】 notice ${notifyUrl}`, 'orderId:', orderId, 'result:', ret.status, JSON.stringify(ret.data));
      if (ret.status === 200) {
        await order.update({ notice: '1' });
      }
    } else {
      ctx.logger.info('【Partner】 notice no send', 'orderId:', orderId);
    }
    return;
  }

  async appKeyLimit(appKey) {
    const { ctx, partnerAPI: { redisappKeyLimitPrefix } } = this;
    let data = await this.app.redis.get(redisappKeyLimitPrefix);
    data = JSON.parse(data);
    if (data) {
      if (data.includes(appKey)) {
        let limit = await this.app.redis.get(redisappKeyLimitPrefix + appKey);
        if (limit) {
          limit = JSON.parse(limit);
          if (limit.currentCount >= limit.limitCount) {
            ctx.throw(422, { message: 'appKey查询数量超过限制,请联系技术人员' });
          } else {
            // limit.currentCount++;
            // await this.app.redis.set(redisappKeyLimitPrefix + appKey, JSON.stringify({ currentCount: limit.currentCount, limitCount: limit.limitCount }), 'EX', 300);
            await ctx.model.query('UPDATE node_limit set currentCount = currentCount + 1  where appKey = ?', {
              type: 'UPDATE',
              replacements: [appKey],
            });
          }
        }
      }
    } else {
      const dbRes = await ctx.model.NodeLimit.findAll({
        attributes: ['appKey', 'currentCount', 'limitCount'],
        where: { type: 'gjj' },
      });
      if (dbRes) {
        const appKeyArray = [];
        for (const item of dbRes) {
          const { appKey, currentCount, limitCount } = item;
          appKeyArray.push(appKey);
          await this.app.redis.set(redisappKeyLimitPrefix + appKey, JSON.stringify({ currentCount, limitCount }), 'EX', 300);
        }
        await this.app.redis.set(redisappKeyLimitPrefix, JSON.stringify(appKeyArray), 'EX', 300);
        if (appKeyArray.includes(appKey)) {
          await ctx.model.query('UPDATE node_limit set currentCount = currentCount + 1  where appKey = ?', {
            type: 'UPDATE',
            replacements: [appKey],
          });
        }
      }
    }
  }

}

module.exports = PartnerService;
