const Subscription = require('egg').Subscription;

class UpdateCache extends Subscription {
    // 通过 schedule 属性来设置定时任务的执行间隔等配置
    static get schedule() {
        return {
            interval: '5m', // 5分钟间隔
            type: 'all', // 所有woker
            immediate: true,
        };
    }

    // subscribe 是真正定时任务执行时被运行的函数
    async subscribe() {
        try {
            const { ctx } = this;
            const { host, customerUrl } = ctx.app.config.signatureAPI;
            const notifyMap = new Map();
            const ret = await ctx.curl(host + customerUrl, {
                charset: 'utf-8',
                timeout: ['30s', '30s'],
                dataType: 'json',
                contentType: 'json',
            });
            // ctx.logger.info(JSON.stringify(ret.data));
            if (ret.data.code == '0') {
                ret.data.data.customerList.map(customer => {
                    if ('callBackUrl' in customer) {
                        notifyMap.set(customer.appKey, { notifyUrl: customer.callBackUrl });
                    }
                });
                ctx.app.notifyMap = notifyMap;
            }
        } catch (e) {
            this.ctx.logger.error('【schedule/notifyUrlTask】catch error:', JSON.stringify(e));
        }
    }
}

module.exports = UpdateCache;