'use strict';

module.exports = app => {
  const { DataTypes } = app.Sequelize;

  const taskStatsu = app.model.define('taskStatsu', {
    id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      autoIncrement: true,
      primaryKey: true,
      field: 'id',
    },
    orderId: {
      type: DataTypes.STRING(255),
      allowNull: false,
      defaultValue: '',
      field: 'orderId',
    },
    taskId: {
      type: DataTypes.STRING(255),
      allowNull: true,
      defaultValue: '',
      field: 'taskId',
    },
    userId: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: '',
      field: 'userId',
    },
    cityId: {
      type: DataTypes.STRING(255),
      allowNull: true,
      defaultValue: '',
      field: 'cityId',
    },
    appKey: {
      type: DataTypes.STRING(255),
      allowNull: false,
      field: 'appKey',
    },
    notifyUrl: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: '',
      field: 'notifyUrl',
    },
    backUrl: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: '',
      field: 'backUrl',
    },
    status: {
      type: DataTypes.STRING(255),
      allowNull: true,
      defaultValue: '',
      field: 'status',
    },
    note: {
      type: DataTypes.STRING(8000),
      allowNull: true,
      defaultValue: '',
      field: 'note',
      get() {
        const note = this.getDataValue('note');
        if (note) {
          try {
            return JSON.parse(note);
          } catch (error) {
            return {};
          }
        }
        return {};
      },
      set(val) {
        this.setDataValue('note', JSON.stringify(val));
      },
    },
    createDate: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: app.Sequelize.literal('CURRENT_TIMESTAMP'),
      field: 'createDate',
    },
    updateDate: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: app.Sequelize.literal('CURRENT_TIMESTAMP'),
      field: 'updateDate',
    },
    text1: {
      type: DataTypes.STRING(255),
      allowNull: true,
      defaultValue: '',
      field: 'text1',
    },
    text2: {
      type: DataTypes.STRING(255),
      allowNull: true,
      defaultValue: '',
      field: 'text2',
    },
    notice: {
      type: DataTypes.STRING(20),
      allowNull: true,
      defaultValue: '',
      field: 'notice',
    },
  },
    {
      tableName: 'gjj_status',
      timestamps: false,
    });

  return taskStatsu;
};
