'use strict';

const Service = require('egg').Service;

class OrderService extends Service {
  async getOneByOrderId(params) {
    const { ctx } = this;
    const order = await ctx.model.TaskStatus.findOne({
      where: params,
    });
    return order;
  }
  async getOneByTaskId(taskId) {
    const { ctx } = this;
    const order = await ctx.model.TaskStatus.findOne({
      where: { taskId },
    });
    return order;
  }

  async create(params) {
    const { ctx } = this;
    await ctx.model.TaskStatus.create(params);
    return;
  }

  async update(params) {
    const { ctx } = this;
    const order = await ctx.model.TaskStatus.findAll({
      where: { orderId: params.orderId },
      order: [['createDate', 'DESC']],
    });
    if (order.length === 0) {
      ctx.throw(400, { message: 'no order' });
      return;
    }
    for (const item of order) {
      if (item.status === 'success') {
        ctx.throw(400, { message: 'orderId success' });
        return;
      }
    }
    const { appKey, taskId, notifyUrl, backUrl, userId } = order[0];
    if (taskId) {
      await ctx.model.TaskStatus.create({ appKey, status: 'init', notifyUrl, backUrl, userId, ...params });
    } else {
      await order[0].update(params);
    }
    await ctx.nodemodel.GjjStatus.findOrCreate({
      where: {
        orderId: params.orderId,
      },
      defaults: {
        appkey: appKey,
        orderId: params.orderId,
        callbackUrl: notifyUrl,
        taskId: params.taskId,
        cityId: params.cityId,
        userId,
        status: 'init',
      },
    })
      .spread(async (info, created) => {
        if (created === false) {
          await info.update({ taskId, cityId: params.cityId, status: 'init' });
        }
      });
    return order[0];
  }

  async oldgjjStatus(params) {
    const { ctx } = this;
    await ctx.nodemodel.GjjStatus.update({ status: params.status }, {
      where: {
        orderId: params.orderId,
      },
      limit: 1,
    });
  }

}

module.exports = OrderService;
