'use strict';

const Controller = require('egg').Controller;

class ScriptController extends Controller {

  constructor(ctx) {
    super(ctx);
    this.cityListRule = {
      appKey: 'string',
    };
  }
  async fetchScripts() {
    const { ctx, service } = this;
    const { appKey } = ctx.query;
    let limitScriptsList = false;
    let excludeTab = true;
    if (appKey) {
      const ret = await service.partner.fetchInfo(appKey);
      if (ret) {
        limitScriptsList = ret.hfExcludeScripts;
        excludeTab = ret.excludeTab;
      }
    }
    let data = await service.scripts.fetchScripts();
    if (limitScriptsList) {
      if (excludeTab) {
        data = data.filter(item => {
          return !(limitScriptsList.includes(item.hub_id));
        });
      } else {
        data = data.filter(item => {
          return (limitScriptsList.includes(item.hub_id));
        });
      }
    }
    data = data.filter(item => {
      return !(item.state === 'none');
    });
    ctx.success(data);
  }

  async partnerScripts() {
    const { ctx, service } = this;
    try {
      ctx.validate(this.cityListRule, ctx.query);
      const { appKey } = ctx.query;
      let limitScriptsList = false;
      const ret = await service.partner.fetchInfo(appKey);
      if (ret) {
        limitScriptsList = ret.hfExcludeScripts;
      } else {
        ctx.error({ message: '无效的appKey' });
        return;
      }
      let data = await service.scripts.fetchScripts();
      if (limitScriptsList) {
        data = data.filter(item => {
          if (item.state === 'offline' || item.state === 'online') {
            return !(limitScriptsList.includes(item.id));
          }
        });
      }
      ctx.body = {
        code: 0,
        data,
      };
    } catch (err) {
      ctx.error(err);
    }
  }

  async fetchOneScripts() {
    const { ctx, service } = this;
    let { scriptId } = ctx.params;
    if (scriptId === 'auto') {
      const ret = await service.scripts.fetchScriptIdByIp();
      scriptId = ret.scriptId;
    }
    const data = await service.scripts.fetchOneScripts(scriptId);
    ctx.success(data);
  }
  async fetchParamsInfo() {
    const { ctx, service } = this;
    const { refresh = false } = ctx.query;
    const data = await service.scripts.fetchParams(refresh);
    ctx.success(data);
  }

  async fetchHelpInfo() {
    const { ctx, service } = this;
    const { scriptId } = ctx.params;
    const data = await service.scripts.fetchHelp(scriptId);
    ctx.success(data);
  }

  async fetchQueryButtonInfo() {
    const { ctx, service } = this;
    const { scriptId } = ctx.params;
    const data = await service.scripts.fetchQueryButton(scriptId);
    ctx.success(data);
  }

  async fetchNoticeInfo() {
    const { ctx, service } = this;
    const { scriptId } = ctx.params;
    const data = await service.scripts.fetchNotice(scriptId);
    ctx.success(data);
  }

  async fetchHubSeripts() {
    const { ctx, service } = this;
    let { hubId } = ctx.params;
    const { appKey } = ctx.query;
    if (hubId === 'auto') {
      const ret = await service.scripts.fetchScriptIdByIp();
      hubId = ret.hubId;
    }
    let limitScriptsList = false;
    let excludeTab = true;
    if (appKey) {
      const ret = await service.partner.fetchInfo(appKey);
      if (ret) {
        limitScriptsList = ret.hfExcludeScripts;
        excludeTab = ret.excludeTab;
      }
    }
    if (limitScriptsList) {
      if (excludeTab) {
        if (limitScriptsList.includes(Number(hubId))) {
          hubId = 1;
        }
      } else {
        if (!limitScriptsList.includes(Number(hubId))) {
          hubId = limitScriptsList[0];
        }
      }
    }
    const data = await service.scripts.fetchHubSeripts(hubId);
    const array = [];
    for (const element of data) {
      if (element.state === 'online') {
        array.unshift(element);
      } else if (element.state !== 'none') {
        array.push(element);
      }
    }
    ctx.success(array);
  }
}

module.exports = ScriptController;
