'use strict';

class sbobj {
    constructor() {
        this.date = '';
        this.medical = {
            base: '',
            amount: '',
            personbase: '',
            companybase: '',
            company: ''
        };
        this.endowment = {
            base: '',
            amount: '',
            personbase: '',
            companybase: '',
            company: ''
        };
        this.Unemployment = {
            base: '',
            amount: '',
            personbase: '',
            companybase: ''
        };
        this.Birth = {
            base: '',
            amount: '',
            personbase: '',
            companybase: ''
        };
        this.Injury = {
            base: '',
            amount: '',
            personbase: '',
            companybase: ''
        }
    }
}


function dealhtml(b) {
    let headerhtml = '<div class="header"><label class="active">缴纳详情</label><label>医保信息</label><label class="">养老信息</label></div>';
    let totalhtml = editsbHtml(b.data.shebaoData.data, b.data.shebaoData.cityName);
    let medicalhtml = editmedicalHtml(b.data.shebaoData.data.医疗数据, b.data.shebaoData.cityName);
    let endowmenthtml = editendowmentHtml(b.data.shebaoData.data.养老数据, b.data.shebaoData.cityName);

    let html = {
        headerhtml: headerhtml,
        totalhtml: totalhtml,
        medicalhtml: medicalhtml,
        endowmenthtml: endowmenthtml
    }
    return html;
}


function editsbHtml(sbdata, cityName) {
    let html = '';
    let outhtml = '';
    let brief = {
        '身份证': '身份证号',
        '姓名': '姓名',
        '社保编号': '社保编号',
        '参保状态': '参保状态',
        '单位名称': '参保单位',
    }
    let sbdetailsarray = [];
    let sbDate = new Map();
    html += '<div class="sbdata"><div class="sbbrief"><div class="tab-brief">';
    for (let item in brief) {
        if (sbdata.基本信息[item] != '') {
            html += `<div><label class="lab">${brief[item]}:</label><label>${sbdata.基本信息[item]}</label></div>`;
        }
    }
    html += `<div><label class="lab">缴纳中心:</label><label>${cityName}社保中心</label></div></div></div>`

    for (let item of sbdata.医疗数据.流水信息.缴费流水) {
        if (item.缴费日期 != '' && /^[1-9]\d{3}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/.test(item.缴费日期)) {
            if (sbDate.has(item.缴费日期)) {
                sbdetailsarray[sbDate.get(item.缴费日期).tip].medical = {
                    base: item.缴费基数,
                    amount: item.缴费额,
                    personbase: item.个人缴费额,
                    companybase: item.公司缴费额,
                    company: item.公司
                }
            } else {
                sbDate.set(item.缴费日期, {date: item.缴费日期, tip: sbdetailsarray.length});
                let sbobject = new sbobj();
                sbobject.date = item.缴费日期;
                sbobject.medical = {
                    base: item.缴费基数,
                    amount: item.缴费额,
                    personbase: item.个人缴费额,
                    companybase: item.公司缴费额,
                    company: item.公司
                }
                sbdetailsarray.push(sbobject);
            }
        }
    }
    for (let item of sbdata.养老数据.流水信息.缴费流水) {
        if (item.缴费日期 != '' && /^[1-9]\d{3}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/.test(item.缴费日期)) {
            if (sbDate.has(item.缴费日期)) {
                sbdetailsarray[sbDate.get(item.缴费日期).tip].endowment = {
                    base: item.缴费基数,
                    amount: item.缴费额,
                    personbase: item.个人缴费额,
                    companybase: item.公司缴费额,
                    company: item.公司
                }
            } else {
                sbDate.set(item.缴费日期, {date: item.缴费日期, tip: sbdetailsarray.length});
                let sbobject = new sbobj();
                sbobject.date = item.缴费日期;
                sbobject.endowment = {
                    base: item.缴费基数,
                    amount: item.缴费额,
                    personbase: item.个人缴费额,
                    companybase: item.公司缴费额,
                    company: item.公司
                }
                sbdetailsarray.push(sbobject);
            }
        }
    }
    for (let item of sbdata.失业数据.流水信息.缴费流水) {
        if (item.缴费日期 != '' && /^[1-9]\d{3}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/.test(item.缴费日期)) {
            if (sbDate.has(item.缴费日期)) {
                sbdetailsarray[sbDate.get(item.缴费日期).tip].Unemployment = {
                    base: item.缴费基数,
                    amount: item.缴费额,
                    personbase: item.个人缴费额,
                    companybase: item.公司缴费额
                }
            } else {
                sbDate.set(item.缴费日期, {date: item.缴费日期, tip: sbdetailsarray.length});
                let sbobject = new sbobj();
                sbobject.date = item.缴费日期;
                sbobject.Unemployment = {
                    base: item.缴费基数,
                    amount: item.缴费额,
                    personbase: item.个人缴费额,
                    companybase: item.公司缴费额
                }
                sbdetailsarray.push(sbobject);
            }
        }
    }
    for (let item of sbdata.生育数据.流水信息.缴费流水) {
        if (item.缴费日期 != '' && /^[1-9]\d{3}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/.test(item.缴费日期)) {
            if (sbDate.has(item.缴费日期)) {
                sbdetailsarray[sbDate.get(item.缴费日期).tip].Birth = {
                    base: item.缴费基数,
                    amount: item.缴费额,
                    personbase: item.个人缴费额,
                    companybase: item.公司缴费额
                }
            } else {
                sbDate.set(item.缴费日期, {date: item.缴费日期, tip: sbdetailsarray.length});
                let sbobject = new sbobj();
                sbobject.date = item.缴费日期;
                sbobject.Birth = {
                    base: item.缴费基数,
                    amount: item.缴费额,
                    personbase: item.个人缴费额,
                    companybase: item.公司缴费额
                }
                sbdetailsarray.push(sbobject);
            }
        }
    }
    for (let item of sbdata.工伤数据.流水信息.缴费流水) {
        if (item.缴费日期 != '' && /^[1-9]\d{3}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/.test(item.缴费日期)) {
            if (sbDate.has(item.缴费日期)) {
                sbdetailsarray[sbDate.get(item.缴费日期).tip].Injury = {
                    base: item.缴费基数,
                    amount: item.缴费额,
                    personbase: item.个人缴费额,
                    companybase: item.公司缴费额
                }
            } else {
                sbDate.set(item.缴费日期, {date: item.缴费日期, tip: sbdetailsarray.length});
                let sbobject = new sbobj();
                sbobject.date = item.缴费日期;
                sbobject.Injury = {
                    base: item.缴费基数,
                    amount: item.缴费额,
                    personbase: item.个人缴费额,
                    companybase: item.公司缴费额
                }
                sbdetailsarray.push(sbobject);
            }
        }
    }

    let compare = function (obj1, obj2) {
        let val1 = obj1.date;
        let val2 = obj2.date;
        if (val1 < val2) {
            return 1;
        } else if (val1 > val2) {
            return -1;
        } else {
            return 0;
        }
    }
    sbdetailsarray.sort(compare);
    let yearSet = new Set();
    html += '<div class="sbdetail">';
    outhtml += `<div class="ui-overlay"></div><div class="dialog">`;
    sbdetailsarray.forEach(function (item, index) {
        let year = item.date.substr(0, 4);
        if (yearSet.has(year)) {
            html += `<li class="detail-tab" data-id="${index}"><label>${item.date.substr(5, 8)}</label><div><p>+${(Number(item.medical.amount) + Number(item.endowment.amount) + Number(item.Birth.amount) + Number(item.Unemployment.amount) + Number(item.Injury.amount)).toFixed(2)}</p>
                        <p>个人:${(Number(item.medical.personbase) + Number(item.endowment.personbase) + Number(item.Birth.personbase) + Number(item.Unemployment.personbase) + Number(item.Injury.personbase)).toFixed(2)}
                         单位: ${(Number(item.medical.companybase) + Number(item.endowment.companybase) + Number(item.Birth.companybase) + Number(item.Unemployment.companybase) + Number(item.Injury.companybase)).toFixed(2)}
                          基数:${item.medical.base || item.endowment.base || ''} </p><p>${item.medical.company || item.endowment.company || ''}</p></div></li>`;
        } else {
            if (yearSet.size > 0) {
                html += '</ul></li></ul>';
            }
            yearSet.add(year);
            html += `<ul><li><h5>${year}年</h5><ul><li class="detail-tab" data-id="${index}"><label>${item.date.substr(5, 8)}</label><div><p>+${(Number(item.medical.amount) + Number(item.endowment.amount) + Number(item.Birth.amount ? item.Birth.amount : '0') + Number(item.Unemployment.amount) + Number(item.Injury.amount)).toFixed(2)}</p>
                        <p>个人:${(Number(item.medical.personbase) + Number(item.endowment.personbase) + Number(item.Birth.personbase) + Number(item.Unemployment.personbase) + Number(item.Injury.personbase)).toFixed(2)}
                         单位: ${(Number(item.medical.companybase) + Number(item.endowment.companybase) + Number(item.Birth.companybase) + Number(item.Unemployment.companybase) + Number(item.Injury.companybase)).toFixed(2)}
                          基数:${item.medical.base || item.endowment.base || ''} </p><p>${item.medical.company || item.endowment.company || ''}</p></div></li>`;
        }
        outhtml += `<div class="dialog-body" data-id="${index}"><img class="left" data-id="${index}" src="/shebao/css/img/left.png"><img class="right" data-id="${index}" src="/shebao/css/img/right.png"><div class="dialog-title">${item.date}</div><div class="dialog-wrapper"><table class="dialog-content">
        <tr><th>险种</th><th>个人缴纳</th><th>单位缴纳</th><th>合计缴纳</th></tr>
         <tr><th>养老</th><td>${item.endowment.personbase}</td><td>${item.endowment.companybase}</td><td>${(Number(item.endowment.companybase) + Number(item.endowment.personbase)).toFixed(2)}</td></tr>
          <tr><th>医疗</th><td>${item.medical.personbase}</td><td>${item.medical.companybase}</td><td>${(Number(item.medical.companybase) + Number(item.medical.personbase)).toFixed(2)}</td></tr>
           <tr><th>工伤</th><td>${item.Injury.personbase}</td><td>${item.Injury.companybase}</td><td>${(Number(item.Injury.companybase) + Number(item.Injury.personbase)).toFixed(2)}</td></tr>
            <tr><th>失业</th><td>${item.Unemployment.personbase}</td><td>${item.Unemployment.companybase}</td><td>${(Number(item.Unemployment.companybase) + Number(item.Unemployment.personbase)).toFixed(2)}</td></tr>
             <tr><th>生育</th><td>${item.Birth.personbase}</td><td>${item.Birth.companybase}</td><td>${(Number(item.Birth.companybase) + Number(item.Birth.personbase)).toFixed(2)}</td></tr>
              <tr><th>合计</th><td>${(Number(item.endowment.personbase) + Number(item.medical.personbase) + Number(item.Injury.personbase) + Number(item.Unemployment.personbase) + Number(item.Birth.personbase)).toFixed(2)}</td>
              <td>${(Number(item.endowment.companybase) + Number(item.medical.companybase) + Number(item.Injury.companybase) + Number(item.Unemployment.companybase) + Number(item.Birth.companybase)).toFixed(2)}</td>
              <td>${(Number(item.endowment.companybase) + Number(item.medical.companybase) + Number(item.Injury.companybase) + Number(item.Unemployment.companybase) + Number(item.Birth.companybase) + Number(item.endowment.personbase) + Number(item.medical.personbase) + Number(item.Injury.personbase) + Number(item.Unemployment.personbase) + Number(item.Birth.personbase)).toFixed(2)}</td></tr></table></div></div>`

    })

    outhtml += '</div>';
    html += '</ul></li></div></div>' + outhtml;
    return html;
}

function editmedicalHtml(medicaldata, cityName) {
    let html = '';
    let sbdetailsarray = [];
    html += `<div class="medical"><div class="tab-nav"><label class="tab-lab active" >医保缴纳</label><label class="tab-lab" >医疗消费</label><span class="cursor"></span></div>`
    html += `<div class="med"><div class="medicalpay"><div class="medicalpaytotal"><div class="medicalpayinline"><div><p>医保账户(元)</p></div><label>${Number(medicaldata.基本信息.历年余额 == undefined ? '0.00' : medicaldata.基本信息.历年余额) + Number(medicaldata.基本信息.当年余额 == undefined ? '0.00' : medicaldata.基本信息.当年余额)}</label>
    <div><p>当年账户余额(元)</p><p>历年账户余额(元)</p></div><div><label>${medicaldata.基本信息.当年余额 == undefined ? '--' : medicaldata.基本信息.当年余额}</label><label>${medicaldata.基本信息.历年余额 == undefined ? '--' : medicaldata.基本信息.历年余额}</label></div></div></div></div>`

    for (let item of medicaldata.流水信息.缴费流水) {
        if (item.缴费日期 != '' && /^[1-9]\d{3}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/.test(item.缴费日期)) {
            sbdetailsarray.push({
                date: item.缴费日期,
                base: item.缴费基数,
                amount: item.缴费额,
                personbase: item.个人缴费额,
                companybase: item.公司缴费额,
                company: item.公司,
                balance: item.余额
            });
        }
    }
    let compare = function (obj1, obj2) {
        let val1 = obj1.date;
        let val2 = obj2.date;
        if (val1 < val2) {
            return 1;
        } else if (val1 > val2) {
            return -1;
        } else {
            return 0;
        }
    }
    sbdetailsarray.sort(compare);
    let yearSet = new Set();
    html += '<div class="medicaldetail">';
    for (let item of sbdetailsarray) {
        let year = item.date.substr(0, 4);
        if (yearSet.has(year)) {
            html += `<li class="detail-tab"><label>${item.date.substr(5, 8)}</label><div><p>+${(Number(item.companybase) + Number(item.personbase)).toFixed(2)}</p>
                        <p>个人:${item.personbase || ''}单位: ${item.companybase || ''}基数:${item.base || ''}</p><p>余额:${item.balance || ''}</p><p>${item.company || ''}</p></div></li>`;
        } else {
            if (yearSet.size > 0) {
                html += '</ul></li></ul>';
            }
            yearSet.add(year);
            html += `<ul><li><h5>${year}年</h5><ul><li class="detail-tab"><label>${item.date.substr(5, 8)}</label><div><p>+${(Number(item.companybase) + Number(item.personbase)).toFixed(2)}</p>
                        <p>个人:${item.personbase || ''}单位: ${item.companybase || ''}基数:${item.base || ''}</p><p>余额:${item.balance || ''}</p><p>${item.company || ''}</p></div></li>`;
        }
    }
    html += '</div></div>';
    html += `<div class="medshop"><div class="medicalpay"><div class="medicalpaytotal"><div class="medicalpayinline">
    <div><p>当年支付累计(元)</p><p>历年支付累计(元)</p></div><div><label>${medicaldata.基本信息.当年使用额 == undefined ? '--' : medicaldata.基本信息.当年使用额}</label><label>${medicaldata.基本信息.历年使用额 == undefined ? '--' : medicaldata.基本信息.历年使用额}</label></div></div></div></div>`

    let sbmeddetailsarray = [];
    for (let item of medicaldata.流水信息.使用流水) {
        if (item.发放年月日 != '' && /^[1-9]\d{3}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/.test(item.发放年月日)) {
            sbmeddetailsarray.push({
                date: item.发放年月日,
                type: item.业务描述,
                amount: item.发生金额,
                personbase: item.个人支付,
                companybase: item.基金账户支付,
                company: item.医疗机构名称,
                balance: item.余额
            });
        }
    }
    sbmeddetailsarray.sort(compare);
    yearSet = new Set();
    html += '<div class="medicaldetail">';
    for (let item of sbmeddetailsarray) {
        let year = item.date.substr(0, 4);
        if (yearSet.has(year)) {
            html += `<li class="detail-tab"><label>${item.date.substr(5, 8)}</label><div>
                        <p style="color: black">医疗类别:${item.type || ''}</p><p>医疗总费用:${item.amount || ''}</p><p>医保支付:${item.companybase || ''}</p><p>${item.company || ''}</p></div></li>`;
        } else {
            if (yearSet.size > 0) {
                html += '</ul></li></ul>';
            }
            yearSet.add(year);
            html += `<ul><li><h5>${year}年</h5><ul><li class="detail-tab"><label>${item.date.substr(5, 8)}</label><div>
                        <p style="color: black">医疗类别:${item.type || ''}</p><p>医疗总费用:${item.amount || ''}</p><p>医保支付:${item.companybase || ''}</p><p>${item.company || ''}</p></div></li>`;
        }
    }
    html += '</div></div>'
    return html;
}

function editendowmentHtml(endowmentdata, cityName) {
    let html = '';
    let sbdetailsarray = [];
    html += `<div class="endowment"><div class="tab-nav"><label class="tab-lab active" >养老缴纳</label><label class="tab-lab" >养老支出</label><span class="cursor"></span></div>`
    html += `<div class="end"><div class="endowmentpay"><div class="endowmentpaytotal"><div class="endowmentpayinline"><div><p>养老账户(元)</p></div><label>--</label>
    </div></div></div>`

    for (let item of endowmentdata.流水信息.缴费流水) {
        if (item.缴费日期 != '' && /^[1-9]\d{3}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/.test(item.缴费日期)) {
            sbdetailsarray.push({
                date: item.缴费日期,
                base: item.缴费基数,
                amount: item.缴费额,
                personbase: item.个人缴费额,
                companybase: item.公司缴费额,
                company: item.公司,
                balance: item.余额
            });
        }
    }
    let compare = function (obj1, obj2) {
        let val1 = obj1.date;
        let val2 = obj2.date;
        if (val1 < val2) {
            return 1;
        } else if (val1 > val2) {
            return -1;
        } else {
            return 0;
        }
    }
    sbdetailsarray.sort(compare);
    let yearSet = new Set();
    html += '<div class="endowmentdetail">';
    for (let item of sbdetailsarray) {
        let year = item.date.substr(0, 4);
        if (yearSet.has(year)) {
            html += `<li class="detail-tab"><label>${item.date.substr(5, 8)}</label><div><p>+${(Number(item.companybase) + Number(item.personbase)).toFixed(2)}</p>
                        <p>个人:${item.personbase || ''}单位: ${item.companybase || ''}基数:${item.base || ''}</p><p>余额:${item.balance || ''}</p><p>${item.company || ''}</p></div></li>`;
        } else {
            if (yearSet.size > 0) {
                html += '</ul></li></ul>';
            }
            yearSet.add(year);
            html += `<ul><li><h5>${year}年</h5><ul><li class="detail-tab"><label>${item.date.substr(5, 8)}</label><div><p>+${(Number(item.companybase) + Number(item.personbase)).toFixed(2)}</p>
                        <p>个人:${item.personbase || ''}单位: ${item.companybase || ''}基数:${item.base || ''}</p><p>余额:${item.balance || ''}</p><p>${item.company || ''}</p></div></li>`;
        }
    }
    html += '</div></div>';

    html += `<div class="endpay">`

    let sbmeddetailsarray = [];
    for (let item of endowmentdata.流水信息.使用流水) {
        if (item.发放年月 != '' && /^[1-9]\d{3}(0[1-9]|1[0-2])$/.test(item.发放年月)) {
            sbmeddetailsarray.push({
                date: item.发放年月,
                type: item.业务描述,
                amount: item.发放总额,
                realpay: item.实发金额,
                cutpay: item.代扣总额
            });
        }
    }
    sbmeddetailsarray.sort(compare);
    yearSet = new Set();
    html += '<div class="endowmentdetail">';
    for (let item of sbmeddetailsarray) {
        let year = item.date.substr(0, 4);
        if (yearSet.has(year)) {
            html += `<li class="detail-tab"><label>${item.date.substr(4, 5)}</label><div>
                        <p>发放总额:${item.amount || ''}</p><p>代扣总额:${item.cutpay || ''}</p><p>实发金额:${item.realpay || ''}</p><p>${item.type || ''}</p></div></li>`;
        } else {
            if (yearSet.size > 0) {
                html += '</ul></li></ul>';
            }
            yearSet.add(year);
            html += `<ul><li><h5>${year}年</h5><ul><li class="detail-tab"><label>${item.date.substr(4, 5)}</label><div>
                        <p>发放总额:${item.amount || ''}</p><p>代扣总额:${item.cutpay || ''}</p><p>实发金额:${item.realpay || ''}</p><p>${item.type || ''}</p></div></li>`;
        }
    }
    html += '</div></div></div>'
    return html;

}

module.exports.dealhtml = dealhtml;