!> 特别提醒： <br> 1. 时间戳（timestamp）： 采用北京时间， 时间戳误差60秒内有效。
<br> 2. token： 获取token时，注意防并发，保持同步，以防新token生成后，老token还在使用导致失效。
<br> 3. appKey： 测试appKey的使用次数为2000次，请及时申请并更换为正式appKey。


# 文档更新说明


>| 日期     | 更新内容|
|:--------|---------|
|```2017-04-03```| 新增获取城市配置接口3.4|
|```2017-04-02```| 新增获取城市接口3.3|
|```2018-03-30```| 6.2社保数据总体基本信息以及养老、医疗、工伤、失业、生育基本信息里新增“参保状态标记” 字段。每个险种缴费流水新增“缴费状态标记”字段|
|```2017-12-08```| 6.2社保数据总体结构中 养老 工伤 失业 基本信息里新增“缴费基数” 字段|




# **2** 接入网址说明

## **2.1** 协议说明

> 只支持https

## **1.2** 域名说明

>| 名称     | 域名| 
|:--------|---------:|
| H5| ```https://t.51gjj.com/```|

# **3** API接口

## **3.1** 获取访问令牌

    

>**请求URL：** 
- ` shebao/getToken `
  
------------

>**请求方式：**


>- Method: POST
- Content-Type: application/json
- Charset: UTF-8

------------


> **参数：** 
>
|参数名|必选|类型|说明|
|:----    |:---|:----- |-----   |
|sign |是  |String |签名   |
|appKey |是  |String |公钥   |
|timestamp |是  |String | 时间戳 （单位：ms）   |

------------

 >**请求示例**


``` json

{
	"sign":"SDSKKL5KJJKLL6JK1L",
	"params":{
		"appKey":"3FD179425381644F95424B66BE06E3E4",
		"timestamp":"1494828184314"
	}
}
```


 >**返回示例1**

``` json
{
  "code": 0,
  "data": {
    "token": "cd4283827366490eb037bf1b4b28dadc"
  }
}
```

 >**返回示例2**

``` json
{
  "code": 101,
  "msg": "参数错误"
}
```

 >**返回参数说明** 

>|参数名|类型|说明|
|:-----  |:-----|-----                           |
|token |String   |访问令牌(Token的有效期为2小时，当Token未失效时调用该接口，则返回新的Token，有效期重新计算，老的Token同时失效) |
|code |Number   |状态码 |
|msg |String   |错误信息 |


------------

 >**备注** 


 >  状态码对应的错误信息
- 0   -> 成功
- -1  -> 系统异常
- 101 -> 参数错误
- 102 -> 时间戳超时
- 103 -> 无效的appKey
- 104 -> 签名错误






## **3.2**   创建订单号
    
**简要描述：** 

- 通过该接口创建订单号
订单号是获取数据的唯一标识，请妥善保管

**请求URL：** 
- path ` shebao/getOrderSn `
  
**请求方式：**
- Method: POST
- Content-Type: application/json
- Charset: UTF-8

**参数：** 

|参数名|必选|类型|说明|
|:----    |:---|:----- |-----   |
|sign |是  |string |签名   |
|appKey |是  |string |公钥   |
|token |是  |string | 访问令牌    |
|timestamp |是  |string | 时间戳   （单位：ms）  |



 **请求示例**

``` json
{
	"sign":"SSDDDDDKL5JKLJKL",
	"params":{
		"appKey":"092217B6B52ED02D46EFFFA7CFA20940",
		"timestamp":"1231231212",
		"token":"875587B6B52ED02D46EFFFA7CFA24323"
	}
}
```


 **返回示例1**

``` json
{
"data":{
		"orderSn":"5c1c45c5-5fa7-47c9-9d49-90d314aba85b"
	},
"code":0,
"msg":""
}
```

 **返回示例2**

``` json
{
  "code": 101,
  "msg": "参数错误"
}
```

 **返回参数说明** 

|参数名|类型|说明|
|:-----  |:-----|-----|
|orderSn |String   |订单号  |
|code |Number   |状态码  |
|msg |String   |错误信息  |

 **备注** 

 状态码对应的错误信息
- 0   -> 成功
- -1  -> 系统异常
- 101 -> 参数错误
- 102 -> 时间戳超时
- 103 -> 无效的token
- 104 -> token已失效
- 105 -> 无效的appKey
- 106 -> 签名错误

## **3.3**   获取社保省份与社保中心关系


**简要描述：** 

- 通过该接口获取社保城市配置


**请求URL：** 
- path ` shebao/cityConfig `
  
**请求方式：**
- Method: get
- Content-Type: application/json
- Charset: UTF-8

``` json
{
    "code": 0,
    "data": [
        {
            "provinceName": "浙江省",
            "citys": [
                {
                    "province": 1,
                    "name": "绍兴",
                    "id": 57,
                    "state": 1
                },
                {
                    "province": 1,
                    "name": "金华",
                    "id": 76,
                    "state": 1
                },
                {
                    "province": 1,
                    "name": "杭州",
                    "id": 81,
                    "state": -1
                }
            ]
        },
        {
            "provinceName": "重庆市",
            "citys": [
                {
                    "province": 2,
                    "name": "重庆",
                    "id": 114,
                    "state": 1
                }
            ]
        }
    ]
}
```


 **返回参数说明** 

>|参数名|类型|说明|
|:-----  |:-----|-----    |
|provinceName |String   |省份名称|
|id |int   |城市id|
|province |int   |省份id|
|state |int   |城市状态 1=> 正常，-1=> 维护中|
|province |String   |省份id|
|name |String   |城市名称|


## **3.4**   获取社保中心配置
    
**简要描述：** 

- 通过该接口获取社保中心信息

**请求URL：** 
- path ` shebao/centersInfo `
  
**请求方式：**
- Method: POST
- Content-Type: application/json
- Charset: UTF-8

**参数：** 

|参数名|必选|类型|说明|
|:----    |:---|:----- |-----   |
|sign |是  |string |签名   |
|appKey |是  |string |公钥   |
|token |是  |string | 访问令牌    |
|timestamp |是  |string | 时间戳   （单位：ms）  |



 **请求示例**

``` json
{
	"sign":"90DBD8332F00888CE1E56FE903A361FA",
	"type":"shebao",
	"params":{
		"appKey":"092217B6B52ED02D46EFFDA7CFA20940",
		"timestamp":1522733629351,
		"token":"948ec4ecbae04420a1144b7cc1fa2f18"
	}
}
```


 **返回示例1**

``` json
{
    "code": 0,
    "data": [
        {
            "省份": "浙江省",
            "省份id": 1,
            "城市": [
                {
                    "城市名称": "绍兴",
                    "城市id": 452,
                    "社保中心": [
                        {
                            "中心id": 57,
                            "中心名称": "绍兴社保中心",
                            "官网地址": "http://puser.zjzwfw.gov.cn/sso/usp.do",
                            "状态": "正常",
                            "最近修改时间": "2017-12-19 11:00:30",
                            "基数上限": "14096",
                            "基数下限": "2820",
                            "医疗个人比例": "无",
                            "医疗单位比例": "5",
                            "养老个人比例": "8",
                            "养老单位比例": "14",
                            "失业个人比例": "0.5",
                            "失业单位比例": "0.5",
                            "工伤个人比例": "无",
                            "工伤单位比例": "0.2-2.85",
                            "生育个人比例": "无",
                            "生育单位比例": "0.5",
                            "政策更新时间": "2017.07",
                            "姓名": "完整",
                            "银行卡号": "不存在",
                            "地址": "不存在",
                            "电话号码": "不完整",
                            "单位名称": "不存在",
                            "单位编号": "不存在",
                            "户口所在地": "不存在",
                            "文化程度": "不存在",
                            "用工形式": "不存在",
                            "户口类型": "不存在",
                            "行政职务": "不存在",
                            "银行": "不存在",
                            "人员类别": "不存在",
                            "人员工作状态": "不存在",
                            "参保状态": "不存在",
                            "参加工作时间": "不存在",
                            "出生日期": "可推断 完整",
                            "民族": "不存在",
                            "性别": "完整",
                            "社保卡号": "不存在",
                            "社保编号": "不存在",
                            "身份证": "完整",
                            "政治面貌": "不存在",
                            "失业明细": "不存在",
                            "工伤参保状态": "不存在",
                            "工伤缴存基数": "不存在",
                            "生育缴存基数": "不存在",
                            "工伤明细": "不存在",
                            "生育参保状态": "不存在",
                            "失业月缴": "不存在",
                            "工伤月缴": "不存在",
                            "失业缴存基数": "不存在",
                            "养老参保状态": "不存在",
                            "养老明细": "不存在",
                            "养老月缴": "不存在",
                            "养老缴存基数": "不存在",
                            "医疗明细": "不存在",
                            "医疗月缴": "不存在",
                            "医疗缴费基数": "不存在",
                            "医疗参保状态": "不存在",
                            "生育月缴": "不存在",
                            "失业参保状态": "不存在",
                            "生育明细": "不存在",
                            "养老明细缴费日期": "不存在",
                            "养老缴费状态": "不存在"
                        }
                    ]
                }
            ]
        }
        
        
    ]
}
```

 **返回示例2**

``` json
{
  "code": 101,
  "msg": "参数错误"
}
```

 **返回参数说明** 

见参数名

 **备注** 

 状态码对应的错误信息
- 0   -> 成功
- -1  -> 系统异常
- 101 -> 参数错误
- 102 -> 时间戳超时
- 103 -> 无效的token
- 104 -> token已失效
- 105 -> 无效的appKey
- 106 -> 签名错误









# **4** 打开H5页面

## **4.1** h5访问入口说明
!> 访问之前需要生成签名，生成过程见附录，生成签名的参数是下表内GET参数中参数描述有标注**(签名参数)** 。


 <table>
   <tr>
      <td>DOMAIN</td>
      <td colspan=4>H5域名</td>
    
   </tr>
   <tr>
      <td>PATH</td>
      <td  colspan=4>/shebao</td>
      
   </tr>
   <tr>
      <td>METHOD</td>
      <td colspan=4>GET</td>
      
   </tr>
   <tr>
      <td rowspan=10>GET参数</td>
      <td>参数名</td>
      <td>参数类型</td>
      <td>参数描述</td>
      <td>可空</td>
   </tr>
   
   <tr>
         <td>sign</td>
         <td>string</td>
         <td>签名</td>
         <td>NO</td>
     </tr>
     
   <tr>
      <td>orderSn</td>
      <td>string</td>
      <td>(签名参数)订单号</td>
      <td>NO</td>
   </tr>
   <tr>
      <td>appKey</td>
      <td>string</td>
      <td>(签名参数)平台发放给开发者的标识开发者身份的标识符</td>
      <td>NO</td>
   </tr>
   <tr>
      <td>token</td>
      <td>string</td>
      <td>(签名参数)访问令牌</td>
      <td>NO</td>
   </tr>
   <tr>
      <td>timestamp</td>
      <td>string</td>
      <td>(签名参数)生成签名时的时间戳（单位：ms）</td>
      <td>NO</td>
   </tr>
   <tr>
         <td>redirectUrl</td>
         <td>string</td>
         <td>查询成功后的跳转地址(需要urlencode)</td>
         <td>NO</td>
      </tr>
   <tr>
         <td>cid</td>
         <td>string</td>
         <td>社保中心编号</td>
         <td>YES</td>
      </tr>
      <tr>
        <td>refresh</td>
        <td>string</td>
        <td>刷新标记（1 or 0,详见[4.4](#_44-H5%e4%bb%bb%e5%8a%a1%e5%88%b7%e6%96%b0%e9%97%ae%e9%a2%98)）</td>
        <td>YES</td>
       <tr>
               <td>userId</td>
               <td>string</td>
               <td>接入方用户唯一标识符</td>
               <td>YES</td>
            </tr>
   
  
</table>







## **4.2** 社保查询回调

###   回调说明
>当社保认证结束之后跳转的url 例如: ```https://www.yourcompany.com/shebao/info/```

### 回传参数说明

>当回调的url为http或https协议时，跳转的url会附加回传社保认证订单号信息
信息返回的形式：明文
明文返回如下：

<table>
   <tr>
      <td>GET参数名</td>
      <td>参数类型</td>
      <td>参数描述</td>
   </tr>
   <tr>
      <td>orderSn</td>
      <td>string</td>
      <td>用户对应的订单号</td>
   </tr>
   <tr>
      <td>status</td>
      <td>string</td>
      <td>订单号对应状态(success/failed)</td>
   </tr>
      <tr>
      <td>timestamp</td>
         <td>string</td>
         <td>结束时间戳（单位：ms）</td>
      </tr>
   
</table>


!> 在使用redirectUrl参数时不要忘了urlencode




## **4.3** h5接入常见问题

> - h5页面查询页面如果传入参数 cid  默认返回该社保中心的查询页面，cid 未传时，默认返回杭州社保查询页面
- 认证过程中错误会有提示

## **4.4** H5任务刷新问题

**简要描述：**
> - 对于已经认证成功的订单号，不需要用户重新输入查询参数（图形验证码会以弹窗方式让用户输入），从而获取到该订单号所对应的账号的最新信息

> - 任务刷新需传```已经认证成功```的订单号和刷新标识(refresh=1)，refresh=0 或不存在表示正常查询




# **5**  查询社保数据

    
**简要描述：** 

- 根据订单号查询用户数据

**请求URL：** 
- ` shebao/getData `
  
**请求方式：**
- Method: POST 
- Content_type: application/json
- Charset: UTF-8

**参数：** 

|参数名|必选|类型|说明|
|:----    |:---|:----- |-----   |
|appKey |是  |string |公钥   |
|timestamp |是  |string | 时间戳    |
|sign     |是  |string | 签名    |
|type |是  |string | 任务类型    |
|token |是  |string |访问令牌   |
|orderSn |是  |string | 任务订单号    |

 **请求示例**
 ```json
  {
	"sign":"89D89A1D07E875C649D6A2D01F8E650A",
	"type":"shebao",
	"params":{
		"appKey": "88A03809137291F333BF2679AB85850E",
		"timestamp":"1494316515535",
		"token":"f63bbb7a1c1b497387597efda28a1e3c",
		"orderSn":"4243d640-146a-47d7-97b9-a03681fc9bf8"	
	}
  }
```

 **返回示例1**

```json
  {
      "code":0,
      "msg": "",
      "data": {
        "shebaoData": {
            "data":{
                "基本信息": {},
                "养老数据": {},
                "医疗数据": {},
                "失业数据": {},
                "生育数据": {},
                "工伤数据": {},
                "分析数据": {}   
                //具体数据结构见附录6.2      
            },
            "cityName":"杭州",
            "cityId":"12",
            "orderId":"158ddhkj-jlhlkmsd-4456465sads", 
            "create_date": "2017-10-12 12:26:10"
        }
      }
  }
```
 **返回示例2**

```json
  {
    "code": 105,
    "msg": "无此订单数据"
  }
```

 **返回参数说明** 

|参数名|类型|说明|
|:-----  |:-----|-----                           |
|shebaoData |String   |数据结构参照社保数据结构 |
|code |Number   |状态码  |
|msg |String   |错误信息  |

 **备注** 

状态码对应的错误信息
- 0   -> 成功
- -1  -> 系统异常
- 101 -> 参数错误
- 102 -> 无效的appKey
- 103 -> token已超时
- 104 -> 签名错误
- 105 -> 无此订单数据


# **6** 附录

## **6.1** 签名算法

签名生成的通用步骤如下：

第一步，设所有发送或者接收到的数据为集合M，将集合M内非空参数值的参数按照参数名ASCII码从小到大排序（字典序），使用URL键值对的格式（即key1=value1&key2=value2…）拼接成字符串stringA。

特别注意以下重要规则：

- 参数名ASCII码从小到大排序（字典序）；
- 如果参数的值为空不参与签名；
- 参数名区分大小写；

第二步，在stringA最后拼接上appSecret得到stringSignTemp字符串，并对stringSignTemp进行MD5运算，再将得到的字符串所有字符转换为大写，得到sign值signValue。

举例：
假设传送的参数如下：
``` json
appKey : 88A03809137291F333BF2689AB85850E,
orderSn : 426ea0df-7f1b-4491-8989-5c130291e892,
timestamp : 1494649888152
token : 0eaeb00afcc4448da724d9179a50abe7
```


第一步：对参数按照key=value的格式，并按照参数名ASCII字典序排序如下：
``` javascript
stringA="appKey=092217B6B52ED02D46EFFFA7CFA20940&orderSn=3e993890-ff08-4af5-bb9b-04fda6dd2b78&timestamp=1494669826683&token=8731de2cd2604f4a856f210703541326";
```
第二步：拼接API密钥：
``` javascript
stringSignTemp=stringA+"&appSecret=192006250b4c09247ec02edce69f6a2d"
sign=MD5(stringSignTemp).toUpperCase()="9A0A8659F005D6984697E2CA0A9CF3B7"
```

## **6.2** 社保数据结构


### 总体结构
!> - JSON键值对除了对象、数组以外，其余键值对的值的数据类型均为String,任何字段若未抓取到数据，默认空字符串





```json
{
    "code":0,
    "msg": "",
    "data": {
        "shebaoData": {
                "data":{
                "基本信息": {
                    "姓名": "黄明明",//部分地区数据可能取不全如 *明明 黄**
                    "身份证": "622423199604211158",//部分地区数据可能取不全如 622423********1158
                    "社保编号": "622423199604211158",
                    "社保卡号": "C59807683",
                    "性别": "男",
                    "民族": "汉族",
                    "出生日期": "1996-04-21",
                    "参加工作时间": "",
                    "参保状态": "参保缴费",
                    "人员工作状态": "在职",//官网返回结果 结果不唯一，可能是“在职人员”或其他 后期会优化
                    "人员类别": "无",
                    "政治面貌": "党员",
                    "行政职务": "无",
                    "户口类型": "农业户口",
                    "用工形式": "",
                    "文化程度": "本科",
                    "户口所在地": "浙江省杭州市",
                    "单位编号": "20217302",
                    "单位名称": "杭州煎饼网络技术有限公司",
                    "电话号码": "15658888888",
                    "地址": "浙江省杭州市西湖区",
                    "银行": "中国工商银行",
                    "银行卡号": "564654654654654654",
                    "参保状态标记": 0//0为正常参保，1为非正常参保（未参保或暂停参保等）-1为程序异常
                        },
                "养老数据": {
                    "基本信息": [{
                        "参保类型": "城镇职工",
                        "参保状态": "参保缴费",
                        "参保时间": "2005-08-01",
                        "余额": "21646.77",
                        "缴费基数":"8000",
                        "参保状态标记": 0//0为正常参保，1为非正常参保（未参保或暂停参保等）-1为程序异常
                    }],
                    "流水信息": {
                        "缴费流水": [{
                            "缴费年月": "201712",
                            "缴费日期": "2017-12-01",
                            "缴费基数": "3178.00",
                            "缴费额": "286.02",
                            "公司": "杭州煎饼网络技术有限公司",
                            "个人缴费额": "63.56",
                            "公司缴费额": "572.04",
                            "余额": "21646.77",
                            "补贴": "55.22",
                            "业务描述": "企业养老",
                            "缴费状态": "已实缴",
                            "缴费状态标记": 0//0为已实缴，1为非已实缴（未到账等情况），2为补缴或补收，-1为程序异常
                        }, {
                            "缴费年月": "",
                            "缴费日期": "",
                            "缴费基数": "",
                            "缴费额": "",
                            "公司": "",
                            "个人缴费额": "",
                            "公司缴费额": "",
                            "余额": "",
                            "补贴": "",
                            "业务描述": "",
                            "缴费状态": "",
                            "缴费状态标记": 0//0为已实缴，1为非已实缴（未到账等情况），2为补缴或补收，-1为程序异常
                        }],
                        "使用流水": [{
                            "发放年月": "",
                            "发放总额": "",
                            "代扣总额": "",
                            "实发金额": "",
                            "业务描述": ""
                        }, {
                            "发放年月": "",
                            "发放总额": "",
                            "代扣总额": "",
                            "实发金额": "",
                            "业务描述": ""
                        }]
                    }
                },
                "医疗数据": {
                    "基本信息": [{
                        "参保类型": "基本医疗保险",
                        "参保状态": "正常参保",
                        "参保时间": "",
                        "年度": "2016",
                        "历年余额": "",
                        "当年余额": "173.20",
                        "历年使用额": "0",
                        "当年使用额": "",
                        "历年结转额": "",
                        "当年预划额": "",
                        "当年划入额": "",
                        "当年利息": "",
                        "参保状态标记": 0//0为正常参保，1为非正常参保（未参保或暂停参保等）-1为程序异常
                    }],
                    "流水信息": {
                        "缴费流水": [{
                            "缴费年月": "",
                            "缴费日期": "",
                            "缴费基数": "",
                            "缴费额": "",
                            "公司": "",
                            "个人缴费额": "",
                            "公司缴费额": "",
                            "余额": "",
                            "补贴": "",
                            "业务描述": "",
                            "缴费状态": "",
                            "缴费状态标记": 0//0为已实缴，1为非已实缴（未到账等情况），2为补缴或补收，-1为程序异常
                        }, {
                            "缴费年月": "",
                            "缴费日期": "",
                            "缴费基数": "",
                            "缴费额": "",
                            "公司": "",
                            "个人缴费额": "",
                            "公司缴费额": "",
                            "余额": "",
                            "补贴": "",
                            "业务描述": "",
                            "缴费状态": "",
                            "缴费状态标记": 0//0为已实缴，1为非已实缴（未到账等情况），2为补缴或补收，-1为程序异常
                        }],
                        "使用流水": [{
                            "发放年月日": "",
                            "医疗机构编号": "",
                            "医疗机构名称": "",
                            "发生金额": "",
                            "余额": "",
                            "业务描述": "",
                            "个人支付": "",
                            "基金账户支付": ""
                        }, {
                            "发放年月日": "",
                            "医疗机构编号": "",
                            "医疗机构名称": "",
                            "发生金额": "",
                            "余额": "",
                            "业务描述": "",
                            "个人支付": "",
                            "基金账户支付": ""
                        }]
                    }
                },
                "失业数据": {
                    "基本信息": [{
                        "参保类型": "",
                        "参保状态": "",
                        "参保时间": "",
                        "余额": "",
                        "缴费基数":"",
                        "参保状态标记": 0//0为正常参保，1为非正常参保（未参保或暂停参保等）-1为程序异常
                    }],
                    "流水信息": {
                        "缴费流水": [{
                            "缴费年月": "",
                            "缴费日期": "",
                            "缴费基数": "",
                            "缴费额": "",
                            "个人缴费额": "",
                            "公司缴费额": "",
                            "补贴": "",
                            "业务描述": "",
                            "缴费状态": "",
                            "缴费状态标记": 0//0为已实缴，1为非已实缴（未到账等情况），2为补缴或补收，-1为程序异常
                        }, {
                            "缴费年月": "",
                            "缴费日期": "",
                            "缴费基数": "",
                            "缴费额": "",
                            "个人缴费额": "",
                            "公司缴费额": "",
                            "补贴": "",
                            "业务描述": "",
                            "缴费状态": "",
                            "缴费状态标记": 0//0为已实缴，1为非已实缴（未到账等情况），2为补缴或补收，-1为程序异常
                        }],
                        "使用流水": [{
                            "发放年月": "",
                            "发放总额": "",
                            "代扣总额": "",
                            "实发金额": "",
                            "业务描述": ""
                        }, {
                            "发放年月": "",
                            "发放总额": "",
                            "代扣总额": "",
                            "实发金额": "",
                            "业务描述": ""
                        }]
                    }
                },
                "生育数据": {
                    "基本信息": [{
                        "参保类型": "",
                        "参保状态": "",
                        "参保时间": "",
                        "余额": "",
                        "个人编号": "",
                        "单位编号": "",
                        "缴费基数": "",
                        "参保状态标记": 0//0为正常参保，1为非正常参保（未参保或暂停参保等）-1为程序异常
                    }],
                    "流水信息": {
                        "缴费流水": [{
                            "缴费年月": "",
                            "缴费日期": "",
                            "缴费基数": "",
                            "缴费额": "",
                            "个人缴费额": "",
                            "公司缴费额": "",
                            "补贴": "",
                            "业务描述": "",
                            "缴费状态": "",
                            "缴费状态标记": 0//0为已实缴，1为非已实缴（未到账等情况），2为补缴或补收，-1为程序异常
                        }, {
                            "缴费年月": "",
                            "缴费日期": "",
                            "缴费基数": "",
                            "缴费额": "",
                            "个人缴费额": "",
                            "公司缴费额": "",
                            "补贴": "",
                            "业务描述": "",
                            "缴费状态": "",
                            "缴费状态标记": 0//0为已实缴，1为非已实缴（未到账等情况），2为补缴或补收，-1为程序异常
                        }],
                        "使用流水": [{
                            "生育医院": "",
                            "生育方式": "",
                            "医疗费用": "",
                            "个人支付": "",
                            "基金支付": "",
                            "生育日期": ""
                        }, {
                            "生育医院": "",
                            "生育方式": "",
                            "医疗费用": "",
                            "个人支付": "",
                            "基金支付": "",
                            "生育日期": ""
                        }]
                    }
                },
                "工伤数据": {
                    "基本信息": [{
                        "参保类型": "",
                        "参保状态": "",
                        "参保时间": "",
                        "余额": "",
                        "缴费基数":"",
                        "参保状态标记": 0//0为正常参保，1为非正常参保（未参保或暂停参保等）-1为程序异常
                    }],
                    "流水信息": {
                        "缴费流水": [{
                            "缴费年月": "",
                            "缴费日期": "",
                            "缴费基数": "",
                            "缴费额": "",
                            "个人缴费额": "",
                            "公司缴费额": "",
                            "补贴": "",
                            "业务描述": "",
                            "缴费状态": "",
                            "缴费状态标记": 0//0为已实缴，1为非已实缴（未到账等情况），2为补缴或补收，-1为程序异常
                        }, {
                            "缴费年月": "",
                            "缴费日期": "",
                            "缴费基数": "",
                            "缴费额": "",
                            "个人缴费额": "",
                            "公司缴费额": "",
                            "补贴": "",
                            "业务描述": "",
                            "缴费状态": "",
                            "缴费状态标记": 0//0为已实缴，1为非已实缴（未到账等情况），2为补缴或补收，-1为程序异常
                        }],
                        "使用流水": [{
                            "发放年月": "",
                            "发放总额": "",
                            "代扣总额": "",
                            "实发金额": ""
                        }, {
                            "发放年月": "",
                            "发放总额": "",
                            "代扣总额": "",
                            "实发金额": ""
                        }]
                    }
                },
                "分析数据": {
                    "养老数据": {
                        "连续缴费月数": "41",
                        "累积缴纳月数": "41",
                        "累积断缴月数": "0",
                        "累积断缴次数": "0",
                        "缴费开始日期": "2014-08-01",
                        "缴费截止日期": "2017-12-01"
                    },
                    "医疗数据": {
                        "连续缴费月数": -1,
                        "累积缴纳月数": -1,
                        "累积断缴月数": -1,
                        "累计断缴次数": -1,
                        "缴费开始日期": "2017-10-01",
                        "缴费截至日期": "2017-10-01"
                    },
                    "失业数据": {
                        "连续缴费月数": -1,
                        "累积缴纳月数": -1,
                        "累积断缴月数": -1,
                        "累计断缴次数": -1,
                        "缴费开始日期": "2017-10-01",
                        "缴费截至日期": "2017-10-01"
                    },
                    "生育数据": {
                        "连续缴费月数": -1,
                        "累积缴纳月数": -1,
                        "累积断缴月数": -1,
                        "累计断缴次数": -1,
                        "缴费开始日期": "2017-10-01",
                        "缴费截至日期": "2017-10-01"
                    },
                    "工伤数据": {
                        "连续缴费月数": -1,
                        "累积缴纳月数": -1,
                        "累积断缴月数": -1,
                        "累计断缴次数": -1,
                        "缴费开始日期": "2017-10-01",
                        "缴费截至日期": "2017-10-01"
                    }
                }        
                },
                "cityName":"杭州",
                "cityId":"12",
                "orderId":"158ddhkj-jlhlkmsd-4456465sads", 
                "create_date": "2017-10-12 12:26:10"
            }
    }    
}

``` 

## **6.3** 社保中心编号

>|城市编号|社保中心|
 |:-----  |:-----|
 |56|北京|
 |57|绍兴|
 |58|昆山|
 |59|济南|
 |60|泰安|
 |61|岳阳|
 |62|抚州|
 |63|益阳|
 |64|邵阳|
 |65|长沙|
 |66|株洲|
 |67|三明|
 |68|南平|
 |69|莆田|
 |70|泉州|
 |71|南京|
 |72|淮安|
 |73|泰州|
 |74|连云港|
 |75|佛山|
 |76|金华|
 |77|厦门|
 |78|长春|
 |79|福州|
 |80|上海|
 |81|杭州|
 |82|中山|
 |83|无锡|
 |84|德州|
 |85|合肥|
 |86|石家庄|
 |87|徐州|
 |88|阿克苏|
 |89|大连|
 |90|海口|
 |91|苏州|
 |92|烟台|
 |93|青岛|
 |94|临沂|
 |95|威海|
 |96|安庆|
 |97|宜宾|
 |98|宜昌|
 |99|荆门|
 |100|黄石|
 |102|三亚|
 |103|漯河|
 |104|长治|
 |105|呼和浩特|
 |106|赤峰|
 |107|怀化|
 |108|衡阳|
 |109|郴州|
 |110|鞍山|
 |111|兰州|
 |112|伊犁|
 |113|韶关|
 |114|重庆|
 |115|温州|
 |116|惠州|
 |117|天津|
 |118|塔城|
 |119|宿州|
 |120|伊宁|
 |121|淮北|
 |123|昌吉|
 |125|阜阳|
 |126|蚌埠|
 |128|马鞍山|
 |130|芜湖|
 |131|铜陵|
 |132|黄山|
 |133|六安|
 |135|池州|
 |136|宣城|
 |146|银川|
 |147|阿拉善盟|
 |148|锡林郭勒盟|
 |149|漳州|
 |150|龙岩|
 |151|兴安盟|
 |152|巴彦淖尔|
 |153|鄂尔多斯|
 |154|乌兰察布|
 |155|通辽|
 |156|呼伦贝尔|
 |157|乌海|
 |158|包头|
 |162|宁德|
 |163|嘉峪关|
 |164|贺州|
 |165|来宾|
 |166|河池|
 |167|百色|
 |168|崇左|
 |169|北海|
 |170|钦州|
 |171|玉林|
 |172|贵港|
 |173|梧州|
 |174|柳州|
 |175|桂林|
 |177|南宁|
 |178|广州|
 |179|深圳|
 |180|清远|
 |181|防城港|
 |182|梅州|
 |183|潮州|
 |186|东莞|
 |187|珠海|
 |188|江门|
 |189|肇庆|
 |190|台州|
 |194|丽水|
 |195|衢州|
 |196|舟山|
 |197|嘉兴|
 |198|湖州|
 |199|宁波|
 |200|文山|
 |201|红河|
 |202|楚雄|
 |203|怒江|
 |204|德宏|
 |205|临沧|
 |206|昭通|
 |207|丽江|
 |208|玉溪|
 |209|大理|
 |210|曲靖|
 |211|昆明|
 |212|凉山|
 |213|甘孜|
 |215|雅安|
 |218|巴中|
 |219|攀枝花|
 |220|泸州|
 |221|自贡|
 |222|内江|
 |223|遂宁|
 |224|广安|
 |225|南充|
 |226|德阳|
 |227|绵阳|
 |228|广元|
 |229|成都|
 |230|营口|
 |232|河源|
 |233|湛江|
 |235|运城|
 |236|晋中|
 |237|吕梁|
 |238|忻州|
 |239|晋城|
 |240|阳泉|
 |241|朔州|
 |242|大同|
 |243|太原|
 |244|汕头|
 |245|揭阳|
 |246|云浮|
 |247|阳江|
 |248|茂名|
 |249|乐山|
 |250|六盘水|
 |252|安顺|
 |253|毕节|
 |254|黔东南|
 |255|黔南州|
 |256|邯郸|
 |258|邢台|
 |259|榆林|
 |260|宝鸡|
 |261|铜川|
 |263|襄阳|
 |264|西安|
 |265|哈尔滨|
 |267|莱芜|
 |268|济宁|
 |270|扬州|
 |271|镇江|
 |272|山西省直|
 |273|临汾|
 |274|枣庄|
 |275|日照|
 |276|淄博|
 |277|东营|
 |278|潍坊|
 |279|滨州|
 |280|章丘|
 |281|胶州|
 |282|胶南|
 |283|即墨|
 |284|平度|
 |285|莱西|
 |288|禹城|
 |290|昌邑|
 |297|龙口|
 |300|乳山|
 |301|滕州|
 |302|曲阜|
 |303|兖州|
 |305|肥城|
 |306|沈阳|
 |307|朝阳|
 |308|阜新|
 |309|铁岭|
 |310|抚顺|
 |311|本溪|
 |312|辽阳|
 |313|丹东|
 |314|锦州|
 |315|盘锦|
 |316|葫芦岛|
 |317|瓦房店|
 |319|北票|
 |320|凌源|
 |321|调兵山|
 |322|开原|
 |323|灯塔|
 |324|海城|
 |325|凤城|
 |327|大石桥|
 |328|盖州|
 |329|凌海|
 |330|北宁|
 |331|兴城|
 |332|宿迁|
 |333|盐城|
 |334|南通|
 |335|常州|
 |336|九江|
 |337|南昌|
 |338|景德镇|
 |339|赣州|
 |340|上饶|
 |341|宜春|
 |342|吉安|
 |343|吉林市|
 |346|四平|
 |348|延边州|
 |351|张家界|
 |353|湘潭|
 |354|永州|
 |355|娄底|
 |356|湘西|
 |358|鄂州|
 |361|荆州|
 |363|郑州|
 |364|开封|
 |365|洛阳|
 |366|平顶山|
 |367|安阳|
 |368|鹤壁|
 |369|新乡|
 |371|濮阳|
 |372|许昌|
 |373|三门峡|
 |374|南阳|
 |375|周口|
 |377|信阳|
 |378|齐齐哈尔|
 |386|十堰|
 |387|宜兴|
 |388|江阴|
 |389|邳州|
 |390|新沂|
 |391|金坛|
 |393|吴江|
 |394|常熟|
 |395|张家港|
 |396|太仓|
 |397|如皋|
 |399|大丰|
 |400|高邮|
 |404|句容|
 |405|丹阳|
 |406|兴化|
 |407|姜堰|
 |409|靖江|
 |410|临安|
 |411|富阳|
 |412|建德|
 |413|慈溪|
 |414|余姚|
 |415|奉化|
 |416|平湖|
 |417|海宁|
 |418|桐乡|
 |419|诸暨|
 |420|上虞|
 |421|嵊州|
 |422|江山|
 |423|兰溪|
 |425|义乌|
 |428|温岭|
 |429|瑞安|
 |430|乐清|
 |431|龙泉|
 |432|溧阳|
 |434|淮南|
 |435|鹰潭|
 |436|新余|
 |439|延安|
 |440|达州|
 |441|渭南|
 |442|咸阳|
 |443|商洛|
 |444|汉中|
 |445|安康|
 |446|汕尾|
 |447|商丘|
 |448|恩施州|
 |449|广西省直|
 |450|四川省直|
 |452|吉林省直|
 |453|农安县|
 |454|九台市|
 |455|榆树市|
 |456|德惠市|
 |471|白山市|
 |480|白城市|
 |493|通化市|
 |494|公主岭市|
 |495|双辽市|
 |496|辽源市|
 |497|梅河口市|
 |498|靖宇县|
 |499|扶余县|
 |500|河南省直|
 |503|菏泽|
 |504|西双版纳|
 |505|普洱|
 |506|保山|
 |507|迪庆|
 |509|广东省直|
 |510|江西省直|
 |511|济源|
 |512|阿坝州|
 |514|辽宁省直|
 |522|大冶|
 |523|阳新|



 # **8** F&Q 常见问题解答

 ## **8.1** 界面相关问题

 #### 1、页面及查询流程是什么样子的？


 >  查询流程，可点击放大查看



 > ![step1](media/flow.png)












 ## **8.2** 回调通知相关问题

 ####  1、如何使用跳转URL？

 >- 1、通过跳转URL的方式;在H5页面认证完成后，将会跳转到指定的URL，同时返回订单号(orderSn)作为跳转的URL输入参数。
 >- 2、APP拦截URL;如果希望在APP中获取订单号，以便更多灵活的处理，那么可以在APP中拦截URL，在APP的内核浏览器跳转URL时，可以拦截到跳转的URL，然后根据需要在APP中设计用户交互。这种方式仅适用于APP接入的应用。


 ####  2、支持服务端通知吗？

 >- 支持，任务完成后我们会通过POST请求通知任务的结果。如需使用服务端回调通知，请提供你的回调地址，我们的技术支持人员会为你开通。该通知一般会早于跳转URL通知，需要正确处理两种通知。
 >- 服务端通知参数


 > |参数名|必选|类型|说明|
 |:----    |:---|:----- |-----   |
 |order_id |是  |String |公积金查询任务订单号   |
 |status |是  |String |任务状态(目前该值全为success)   |


 > 当成功收到回调通知后，贵方应返回HttpStatus=200
