!> 特别提醒： <br> 1. 时间戳（timestamp）： 采用北京时间， 时间戳误差60秒内有效。

# **1** 接入网址说明

## **1.1** 协议说明

> 只支持https

## **1.2** 域名说明

>| 名称     | 域名| 
|:--------|---------:|
| H5| ```https://t.51gjj.com/```|


# **2** 打开H5页面

## **2.1** H5访问入口说明
!> 访问之前需要生成校验码，生成过程见[附录3.1](#_31-生成校验码规则) 。

 <table>
    <tr>
        <td>DOMAIN</td>
        <td colspan=4>H5域名</td>
    </tr>
    <tr>
        <td>PATH</td>
        <td  colspan=4>/shebao</td>  
    </tr>
    <tr>
        <td>METHOD</td>
        <td colspan=4>GET</td>      
    </tr>
    <tr>
        <td rowspan=12>GET参数</td>
        <td>参数名</td>
        <td>参数类型</td>
        <td>参数描述</td>
        <td>可空</td>
    </tr>
    <tr>
        <td>timestamp</td>
        <td>string</td>
        <td>生成校验码时的时间戳（单位：ms）</td>
        <td>NO</td>
    </tr>
   <tr>
        <td>checkCode</td>
        <td>string</td>
        <td>校验码</td>
        <td>NO</td>
    </tr>
    <tr>
        <td>channel</td>
        <td>string</td>
        <td>gswechat（必填且写死）</td>
        <td>NO</td>    
    </tr>
    <tr>
        <td>appKey</td>
        <td>string</td>
        <td>平台发放给开发者的标识开发者身份的标识符</td>
        <td>NO</td>    
    </tr>
</table>


# **2** 附录

## **2.1** 生成校验码规则

校验码生成规则：

>- 1、获取当前时间戳```（T）```，精确到毫秒，```13```位。 （转换结果与 http://tool.chinaz.com/Tools/unixtime.aspx  转换的结果保持一致）
>- 2、从T中，获取倒数第二位值```（M）```（若倒数第二位为```0```,则取倒数第三位，若倒数第三位为```0```,则取倒数第四位......直到取到值不为```0```）和倒数第一位值```（N）```
>- 3、以```M*K```(```K```从```0```开始递增，```0，1，2```.....)为间隔，从```T```中取出相应下标对应的值```（A,B,C,D.....）```,```M*K```大于13时取数完成。
>- 4、用第3步的值分别与```N```相加，得到```A1,B1,C1,D1```
>- 5、拼接第4步得到的值，```A1B1C1D1```  该值即为校验码​


示例：

>- 1、获取当前时间戳  ```1522396007568```
>- 2、取出```M=6，N=8```
>- 3、以```M*K```为间隔取出相应下标对应的值，```6*0=0，A=1；6*1=6，B=6；6*2=12，C=8；6*3=18```，大于```13```，取值结束
>- 4、分别与```N```相加，```A1=A+N=9;B1=B+N=14;C1=C+N=16```
>- 5、拼接值 ```A1B1C1 = 91416```
```"91416"```即为校验码


# **4** F&Q 常见问题解答

## **4.1** 界面相关问题

#### 1、接入流程是什么样子的？

>  查询流程，可点击放大查看



> ![flowchart](img/flowchart.png)


#### 2、页面及查询流程是什么样子的？


>  查询流程，可点击放大查看



> ![step1](img/flow.png)
> 结果页
 ![step1](img/show1.png) ![step1](img/show2.png)

