$.setTool = function(c){
    if(typeof window.toolFunClose =="undefined"){
        window.toolFunClose=[];
    }
    for (var i = 0; i < window.toolFunClose.length; i++) {
        window.toolFunClose[i].callback();
    };
    window.toolFunClose=[];
    window.toolFunClose.push({callback:c})
}

$.extend($.fn,{
	valMap:function(){
		var data = {};
		for (var i = 0; i < this.length; i++) {
			var ele = $(this[i]);
			var name = ele.attr('name');
			if (name) {
				data[name]=ele.val();
			}
		}
		return data;
	},
	checkAll:function(strict){
		for (var i = 0; i < this.length; i++) {
			var errmsg = $(this[i]).checkVal(strict);
			if (errmsg) {
				return errmsg;
			}
		}
		return null;
	},
	checkVal:function(strict){
		var self = $(this),val = self.val(),errmsg = null,label = self.data('label');
		if (self.hasClass('required')) {
			if(/^\s*$/.test(val)){
				return (label && (errmsg = '请先填写'+label))||(errmsg = '请填写完所有必填的内容'),errmsg;
			}
		}
		if (self.hasClass('required-checked')&&self.is('[type=checkbox]')){
			if(!self.is(':checked')){
				return self.data('msg')||'请先勾选';
			}
		}
		if (!!strict) {
			if (self.hasClass('useIDCard')) {
				if(!/^\d{14}(\d{3})?[\dXx]$/.test(val)){
	                return '身份证格式不对';
	            }
			}

			if (self.hasClass('userPhone')) {
				if(!/^\d{11}$/.test(val)){
	                return '手机格式不正确';
	            }
			}

			if (self.hasClass("useEmail")) {
                if (!/^(\w)+(\.\w+)*@(\w)+((\.\w+)+)$/.test(val)) {
                    return '邮箱格式不正确';
                }
            }
		}
		return errmsg;
	},
	inteSub:function(selector,doSubmit,doAbort,body){
		var items = body?$(body).find(selector):$(selector);
		var func = (function(items,button){
			return function(){
				for (var i = 0; i < items.length; i++) {
					var r = $(items[i]);
                    if (r.hasClass('ignore')) {
                        continue;
                    }else if (r.is("[type=hidden]")) {
						if (!r.parent().is(":visible")) {
							continue;
						}
					}else if (r.is("[type=checkbox]")) {
						if(!r.is(":visible") && !r.parent().is(":visible")){
							continue;
						}
					}else if(!r.is(":visible")){
						continue;
					}
					var errmsg = r.checkVal();
					if (errmsg) {
						button.addClass('disabled').attr("disabled","disabled");
						return;
					}
				}
				button.removeClass('disabled').removeAttr("disabled");
			}
		})(items,this);
		items.off('input change propertychange').on('input change propertychange',func).eq(0).trigger('input');
		this.off('click').on('click',function(){
			var data = {};
			for (var i = 0; i < items.length; i++) {
				var r = $(items[i]);
				if (r.hasClass('ignore')) {
                    continue;
                }else if (r.is("[type=hidden]")) {
					if (!r.parent().is(":visible")) {
						continue;
					}
				}else if (r.is("[type=checkbox]")) {
					if(!r.is(":visible") && !r.parent().is(":visible")){
						continue;
					}
				}else if(!r.is(":visible")){
					continue;
				}
				var errmsg = r.checkVal(true);
				if (errmsg) {
					typeof doAbort == 'function' && doAbort.call($(this),errmsg);
					return;
				}
				var name = r.attr('name');
				name && !/^\s*$/.test(r.val()) &&(data[name]=r.val());
			}
			typeof doSubmit == 'function' && doSubmit.call($(this),data);
		});
	},
	lock:function(cd){
        var self = $(this),text = self.html(),i = cd;
        self.data('origin-text',text);
        var call = function(){
            if(i>0){
                self.html(i+'秒');
                self.attr("disabled","disabled");
            } else {
                self.html(self.data('origin-text'));
                self.removeAttr("disabled");
                self.data('timer',0);
                clearInterval(timer);
            }
            i--;
        }
        var timer = setInterval(call,1000);
        self.data('timer',timer);
        call();
        var id = self.attr('id');
        if (window.localStorage && id) {
            var cache = window.localStorage['lock_cd'];
            if (cache) {
                cache = JSON.parse(cache);
            }else{
                cache = {}
            }
            cache[id] = Math.round(new Date().getTime()/1000)+cd;
            window.localStorage['lock_cd'] = JSON.stringify(cache);
        }
    },
    unlock:function(){
        var self = $(this);
        self.html(self.data('origin-text'));
        self.removeAttr("disabled");
        var timer = self.data('timer');
        timer && clearInterval(timer);
    }
});

function getURLParams( url ) {
    var urlParts = url.split("?");
    var result = {};
    if( urlParts[1] ) {
        var params = urlParts[1].split("&");

        for ( var i = 0; i < params.length; ++i ) {
            var item = params[i].split("=");
            var key = decodeURIComponent(item[0]);
            var val = decodeURIComponent(item[1]);
            result[key] = val;
        }
    }
    return result;
}

function serializeParams(data){
	var serializedParams = '';
	for (var pro in data) {
		serializedParams += (serializedParams.length?'&':'') + pro + '='+encodeURIComponent(data[pro]);
	}
	return serializedParams;
}