'use strict';

module.exports = app => {
  return {
    schedule: {
      interval: '5m', // 5分钟间隔
      type: 'all',
      immediate: true,
    },

    // 定时操作node_gjj.node_limit表
    async task(ctx) {
      const rows = await ctx.nodeGjj.query('SELECT appKey, currentCount, limitCount, text FROM node_limit WHERE type = shebao', { type: 'SELECT' });
      const map = new Map();
      rows.forEach(item => {
        const { currentCount, limitCount, text } = item;
        const obj = {
          currentCount,
          limitCount,
          env: text,
        };
        map.set(item.appKey, obj);
      });
      ctx.app.modeLimitMap = map;
    },
  };
};
