'use strict';

const Service = require('egg').Service;

class WashDataService extends Service {
  constructor(ctx) {
    super(ctx);
    const { config } = this;
    this.washUrl = config.washAPI.host + config.washAPI.washUrl;
  }
  async wash(data) {
    const { app, washUrl, ctx } = this;
    const rawdata = this._switchData(data);
    const washData = await app.curl(washUrl,
      {
        charset: 'utf-8',
        timeout: ['30s', '30s'],
        dataType: 'json',
        data: rawdata,
        method: 'post',
        contentType: 'json',
      });
    if (washData.status !== 200) {
      ctx.logger.error(`【washData】url${washUrl} ,params`, JSON.stringify(rawdata), JSON.stringify(washData));
      throw new Error('清洗数据出错');
    }
    if (washData.data.code !== 0) {
      ctx.logger.error(`【washData】url${washUrl} ,params`, JSON.stringify(rawdata), JSON.stringify(washData.data));
      throw new Error('清洗数据出错');
    }

    return washData.data;
  }

  _switchData(data) {
    const tmp = data.data;
    const bar = {};
    bar.taskId = tmp.taskId;
    bar.cityId = tmp.cityId;
    bar.data = JSON.parse(tmp.data);
    bar.orderID = 'ttt';
    bar.appKey = '';
    return bar;
  }
}

module.exports = WashDataService;
