'use strict';

module.exports = () => {
  const config = exports = {};
  config.debug = false;

  config.taskAPI = {
    host: process.env.TASKAPI_HOST || 'http://tm.51gjj.com:4831',
    fetchHubsUrl: '',
    createTaskUrl: '/shebao/createSbTask',
    fetchCodeUrl: '/shebao/getSbCode',
    submitTaskUrl: '/shebao/loginSbWeb',
    fetchTaskUrl: '/shebao/getSbData', // 获取该task状态
  };

  config.partnerAPI = {
    host: process.env.PARTNERAPI_HOST || 'https://dev-nginx.jianbing.com/zeus-api/v1',
    fetchTheme: '/chaos/partners/theme',
    fetchScripts: '/chaos/partners/scripts',
    redisThemePrefix: 'URANUS.HF.PARNTERS.THEME',
    redisScriptsPrefix: 'URANUS.HF.PARNTERS.SCRIPTS',
  };

  config.scriptsAPI = {
    host: process.env.SCRIPTSAPI_HOST || 'https://dev-nginx.jianbing.com/zeus-api/v1',
    fetchScriptsUrl: '/chaos/hf/two_dimension_array/queries',
    fetchOneScriptUrl: '/chaos/hf/two_dimension_array/info',
    fetchParamsInfoUrl: '/chaos/hf/login_param_map',
    fetchQueryButtonUrl: '/chaos/hf/query_button',
    fetchHelpUrl: '/chaos/hf/help',
    fetchNoticeUrl: '/chaos/hf/notice',
    fetchHubSeriptsUrl: '/chaos/hf/hubs',
    fetchScriptByCityNameUrl: '/chaos/hf/city_scripts',
    redisScriptsKey: 'URANUS.HF.SCRIPTS',
    redisParamsKey: 'URANUS.HF.PARAMS',
  };

  config.storageAPI = {
    host: process.env.STORAGEAPI_HOST || 'http://tv.51gjj.com:11252',
    writeUrl: '/data',
    readUrl: '/shebao',
    writeType: 'shebao',
    readDataKey: 'shebaoData',
  };

  config.washAPI = {
    host: process.env.WASHAPI_HOST || 'http://tt.51gjj.com:11101',
    washUrl: '/si/analyzeSI',
  };

  config.signatureAPI = {
    host: process.env.SIGNATUREAPI_HOST || 'http://tj3.51gjj.com:5118',
    fetchTokenUrl: '/Access/GetToken',
    fetchOrderIdUrl: '/Order/GetOrderSn',
    signatureUrl: '/Access/SignValidityCheck',
    fetchParnterUrl: '',
    signatureType: 'shebao',
  };

  config.lockKeys = {
    fecthHub: 'NEWSB.HF.HUBS.LOCK',
    fecteToken: 'NEWSB.HF.TOKEN.LOCK',
    token: 'NEWSB.HF.TOKEN',
    fecthParnters: 'NEWSB.PARNTERS.LOCK',
    taskPrefix: 'NEWSB.TASK',
  };

  config.sequelize = {
    datasources: [{
      // 东八时区
      timezone: '+08:00',
      delegate: 'model',
      baseDir: 'model',
      dialect: 'mysql',
      host: process.env.MYSQL_PACHONG_HOST || 'rm-bp1272001633qc0x9.mysql.rds.aliyuncs.com',
      database: process.env.MYSQL_DATA_SERVER_DB_NAME || 'data_service_dev',
      username: process.env.MYSQL_USER || 'hexin',
      password: process.env.MYSQL_PWD || 'gYUHszn9#q',
      port: process.env.MYSQL_PORT || 3306,
    }, {
      // 东八时区
      timezone: '+08:00',
      delegate: 'cusPro',
      baseDir: 'model',
      dialect: 'mysql',
      host: process.env.MYSQL_PACHONG_HOST || 'rm-bp1272001633qc0x9.mysql.rds.aliyuncs.com',
      database: process.env.MYSQL_JAVA_DB_NAME || 'java_open_platform',
      username: process.env.MYSQL_USER || 'hexin',
      password: process.env.MYSQL_PWD || 'gYUHszn9#q',
      port: process.env.MYSQL_PORT || 3306,
    }],
  };

  config.redis = {
    client: {
      port: 6379,
      host: process.env.REDIS_HOST || '116.62.55.137',
      password: process.env.REDIS_PWD || 'DEV8redis',
      db: 0,
    },
  };

  config.SB_OpenAPI = {
    appKey: '60670203E411FD62BA9E953CFB73F881',
    appSecret: '0BDD1ECC147503C477563E5C1438C366D70E4F80',
  };

  config.callbackUrl = process.env.CALLBACK_URL || 'http://ti.51gjj.com:7001/shebao_server/callback';

  return config;
};
