'use strict';

const Controller = require('egg').Controller;

class OrderController extends Controller {
  constructor(ctx) {
    super(ctx);
    this.createRule = {
      appKey: { type: 'string', required: true },
      userId: { type: 'string', required: true },
      notifyUrl: { type: 'string', required: false },
    };

    this.showRule = {
      sign: 'string',
      params: {
        type: 'object',
        rule: {
          token: 'string',
          orderSn: 'string',
          appKey: 'string',
          timestamp: 'string',
        },
      },
    };
  }

  async create() {
    const { ctx, service } = this;
    ctx.validate(this.createRule);
    // const { appKey } = ctx.request.body.params;
    const { appKey, userId, notifyUrl } = ctx.request.body;
    // const orderId = await service.signature.createOrderId(ctx.request.body);
    const orderId = await ctx.helper.getUuid();
    await service.order.create({
      orderId,
      taskId: '',
      userId,
      cityId: '',
      appkey: appKey,
      status: 'init',
      callbackUrl: notifyUrl,
    });
    ctx.success({ orderId });
  }

  async show() {
    const { ctx, service } = this;
    ctx.validate(this.showRule);
    const { orderId } = ctx.params;
    await service.signature.signatureCheck(ctx.request.body);
    const data = await service.order.getOneByOrderId(orderId);
    if (data) {
      if (data.status === 'success') {
        const result = await service.storage.read(orderId);
        ctx.success(result);
        return;
      }
      ctx.success({
        status: data.status,
      });
      return;
    }
    ctx.fail('无此订单号');
  }

  async fetchOrderId() {
    const { ctx, service } = this;
    const token = await service.signature.getToken();
    const signParams = ctx.helper.buildRequestBody({ token });
    const { appKey } = signParams.params;
    const orderId = await service.signature.createOrderId(signParams);
    await service.order.create({
      orderId,
      taskId: '',
      userId: '',
      cityId: '',
      appkey: appKey,
      status: 'init',
    });
    ctx.success({ orderId });
  }
}

module.exports = OrderController;
